/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends AbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity acT;
    private final PlayerEntity afD;
    private final byte[] afk;
    private final String zzcec;
    private final ArrayList<PlayerEntity> afE;
    private final int nV;
    private final long aeD;
    private final long afF;
    private final Bundle afG;
    private final int zzbtt;

    public GameRequestEntity(GameRequest gameRequest) {
        this.mVersionCode = 2;
        this.acT = new GameEntity(gameRequest.getGame());
        this.afD = new PlayerEntity(gameRequest.getSender());
        this.zzcec = gameRequest.getRequestId();
        this.nV = gameRequest.getType();
        this.aeD = gameRequest.getCreationTimestamp();
        this.afF = gameRequest.getExpirationTimestamp();
        this.zzbtt = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.afk = null;
        } else {
            this.afk = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.afk, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.afE = new ArrayList(n);
        this.afG = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.afE.add((PlayerEntity)player);
            this.afG.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n2, long l, long l2, Bundle bundle, int n3) {
        this.mVersionCode = n;
        this.acT = gameEntity;
        this.afD = playerEntity;
        this.afk = byArray;
        this.zzcec = string;
        this.afE = arrayList;
        this.nV = n2;
        this.aeD = l;
        this.afF = l2;
        this.afG = bundle;
        this.zzbtt = n3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzcec;
    }

    @Override
    public Game getGame() {
        return this.acT;
    }

    @Override
    public Player getSender() {
        return this.afD;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.afE);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.afk;
    }

    @Override
    public int getType() {
        return this.nV;
    }

    @Override
    public long getCreationTimestamp() {
        return this.aeD;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.afF;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.afG.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzbtt;
    }

    public Bundle zzbmx() {
        return this.afG;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzz.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzz.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzz.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzz.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzz.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzz.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzz.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzz.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzz.zzx((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

