/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int mVersionCode;
    private final int agv;
    private final int ago;
    private final String agw;
    private final String agx;
    private final String agy;
    private final String agz;
    private final boolean agA;

    private VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this(2, n, n2, string, string2, string3, string4, bl);
    }

    public VideoConfiguration(int n, int n2, int n3, String string, String string2, String string3, String string4, boolean bl) {
        this.mVersionCode = n;
        zzaa.zzbt((boolean)VideoConfiguration.isValidQualityLevel(n2, false));
        zzaa.zzbt((boolean)VideoConfiguration.isValidCaptureMode(n3, false));
        this.agv = n2;
        this.ago = n3;
        this.agA = bl;
        if (n3 == 1) {
            this.agx = string2;
            this.agw = string;
            this.agy = string3;
            this.agz = string4;
        } else {
            zzaa.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzaa.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzaa.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzaa.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.agx = null;
            this.agw = null;
            this.agy = null;
            this.agz = null;
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getQualityLevel() {
        return this.agv;
    }

    public int getCaptureMode() {
        return this.ago;
    }

    public String zzbng() {
        return this.agx;
    }

    public String getStreamUrl() {
        return this.agw;
    }

    public String zzbnh() {
        return this.agy;
    }

    public String zzbni() {
        return this.agz;
    }

    public boolean zzbnj() {
        return this.agA;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int agv;
        private int ago;
        private boolean agA;
        private String agw;
        private String agx;
        private String agy;
        private String agz;

        public Builder(int n, int n2) {
            this.agv = n;
            this.ago = n2;
            this.agA = true;
            this.agw = null;
            this.agx = null;
            this.agy = null;
            this.agz = null;
        }

        public Builder setQualityLevel(int n) {
            this.agv = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.ago = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.agv, this.ago, null, null, null, null, this.agA);
        }
    }
}

