/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzbv;
import com.google.android.gms.internal.ads.zzdlk;
import com.google.android.gms.internal.ads.zzdlo;
import com.google.android.gms.internal.ads.zzdlu;
import com.google.android.gms.internal.ads.zzdlz;
import com.google.android.gms.internal.ads.zzdmb;
import com.google.android.gms.internal.ads.zzdmc;
import com.google.android.gms.internal.ads.zzdmd;
import com.google.android.gms.internal.ads.zzdme;
import com.google.android.gms.internal.ads.zzdmg;
import com.google.android.gms.internal.ads.zzecd;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzdma {
    private final Context zzvf;
    private final zzdlk zzvj;
    private final zzdlo zzxy;
    private final zzdmd zzhbr;
    private final Task<zzbv.zza> zzhbs;
    private final zzdmg zzhbt;
    private final Task<zzbv.zza> zzhbu;

    public zzdma(@NonNull Context context, @NonNull Executor executor, @NonNull zzdlk zzdlk2, @NonNull zzdlo zzdlo2) {
        this(context, executor, zzdlk2, zzdlo2, new zzdmg(), new zzdmd());
    }

    @VisibleForTesting
    private zzdma(Context context, Executor executor, zzdlk zzdlk2, zzdlo zzdlo2, zzdmg zzdmg2, zzdmd zzdmd2) {
        this.zzvf = context;
        this.zzvj = zzdlk2;
        this.zzxy = zzdlo2;
        this.zzhbt = zzdmg2;
        this.zzhbr = zzdmd2;
        this.zzhbs = Tasks.call((Executor)executor, (Callable)new zzdlz(this)).addOnFailureListener((OnFailureListener)new zzdmc(this));
        this.zzhbu = Tasks.call((Executor)executor, (Callable)new zzdmb(this)).addOnFailureListener((OnFailureListener)new zzdme(this));
    }

    private final void zzc(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzvj.zza(2025, -1L, exception);
    }

    private final synchronized zzbv.zza zza(Task<zzbv.zza> task) {
        if (!task.isComplete()) {
            try {
                Tasks.await(task, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                this.zzc(exception);
            }
        }
        if (!task.isSuccessful()) {
            return (zzbv.zza)((zzecd)zzbv.zza.zzar().zzu("E").zzbet());
        }
        return (zzbv.zza)((Object)task.getResult());
    }

    private final synchronized zzbv.zza zzcp() {
        return this.zza(this.zzhbu);
    }

    private final synchronized zzbv.zza zzaum() {
        return this.zza(this.zzhbs);
    }

    public final String zzag() {
        return this.zzcp().zzag();
    }

    public final String zzam() {
        return this.zzaum().zzam();
    }

    public final int zzaun() {
        return this.zzaum().zzan().zzw();
    }

    public final boolean zzao() {
        return this.zzaum().zzao();
    }

    final /* synthetic */ void zzd(Exception exception) {
        this.zzc(exception);
    }

    final /* synthetic */ zzbv.zza zzauo() throws Exception {
        zzdma zzdma2 = this;
        PackageInfo packageInfo = zzdma2.zzvf.getPackageManager().getPackageInfo(zzdma2.zzvf.getPackageName(), 0);
        String string = Integer.toString(packageInfo.versionCode);
        String string2 = zzdma2.zzvf.getPackageName();
        return zzdlu.zzj(zzdma2.zzvf, string2, string);
    }

    final /* synthetic */ void zze(Exception exception) {
        this.zzc(exception);
    }

    final /* synthetic */ zzbv.zza zzaup() throws Exception {
        zzdma zzdma2 = this;
        if (zzdma2.zzxy.zzaug()) {
            String string;
            Context context = zzdma2.zzvf;
            zzbv.zza.zza zza2 = zzbv.zza.zzar();
            AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context);
            advertisingIdClient.start();
            AdvertisingIdClient.Info info = advertisingIdClient.getInfo();
            String string2 = info.getId();
            if (string2 != null && string2.matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
                UUID uUID = UUID.fromString(string2);
                byte[] byArray = new byte[16];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.putLong(uUID.getMostSignificantBits());
                byteBuffer.putLong(uUID.getLeastSignificantBits());
                string2 = Base64.encodeToString((byte[])byArray, (int)11);
            }
            if ((string = string2) != null) {
                zza2.zzaa(string);
                zza2.zza(info.isLimitAdTrackingEnabled());
                zza2.zza(zzbv.zza.zzc.zzin);
            }
            return (zzbv.zza)((zzecd)zza2.zzbet());
        }
        return zzbv.zza.zzas();
    }
}

