/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzb;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Set<String> zzbfR = new HashSet<String>();
    private int zzbfS;
    private ExecutorService zzqt;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzqt = this.zzGd();
    }

    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        List<Runnable> list = this.zzqt.shutdownNow();
        if (!list.isEmpty()) {
            int n = list.size();
            Log.e((String)"GcmTaskService", (String)new StringBuilder(79).append("Shutting down, but not all tasks are finished executing. Remaining: ").append(n).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        try {
            if (intent == null) {
                return 2;
            }
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string)) {
                String string2 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = (Bundle)intent.getParcelableExtra("extras");
                if (parcelable == null || !(parcelable instanceof PendingCallback)) {
                    String string3 = String.valueOf(this.getPackageName());
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Could not process request, invalid callback.").toString());
                    return 2;
                }
                Set<String> set = this.zzbfR;
                synchronized (set) {
                    if (!this.zzbfR.add(string2)) {
                        String string4 = String.valueOf(this.getPackageName());
                        Log.w((String)"GcmTaskService", (String)new StringBuilder(44 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" ").append(string2).append(": Task already running, won't start another").toString());
                        return 2;
                    }
                }
                this.zzqt.execute(new zza(string2, ((PendingCallback)parcelable).getIBinder(), bundle));
                return 2;
            }
            if (SERVICE_ACTION_INITIALIZE.equals(string)) {
                this.onInitializeTasks();
                return 2;
            }
            Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string).length()).append("Unknown action received ").append(string).append(", terminating").toString());
            return 2;
        }
        finally {
            this.zzjs(n2);
        }
    }

    protected ExecutorService zzGd() {
        return Executors.newFixedThreadPool(2, new ThreadFactory(this){
            private final AtomicInteger zzbfT = new AtomicInteger(1);

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                int n = this.zzbfT.getAndIncrement();
                Thread thread = new Thread(runnable, new StringBuilder(20).append("gcm-task#").append(n).toString());
                thread.setPriority(4);
                return thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzjs(int n) {
        Set<String> set = this.zzbfR;
        synchronized (set) {
            this.zzbfS = n;
            if (this.zzbfR.size() == 0) {
                this.stopSelf(this.zzbfS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeH(String string) {
        Set<String> set = this.zzbfR;
        synchronized (set) {
            this.zzbfR.remove(string);
            if (this.zzbfR.size() == 0) {
                this.stopSelf(this.zzbfS);
            }
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    private class zza
    implements Runnable {
        private final String mTag;
        private final zzb zzbfU;
        private final Bundle mExtras;

        zza(String string, IBinder iBinder, Bundle bundle) {
            this.mTag = string;
            this.zzbfU = zzb.zza.zzcV(iBinder);
            this.mExtras = bundle;
        }

        @Override
        public void run() {
            int n = GcmTaskService.this.onRunTask(new TaskParams(this.mTag, this.mExtras));
            try {
                this.zzbfU.zzjt(n);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf(this.mTag);
                Log.e((String)"GcmTaskService", (String)(string.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string) : new String("Error reporting result of operation to scheduler for ")));
            }
            finally {
                GcmTaskService.this.zzeH(this.mTag);
            }
        }
    }
}

