/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.zza;
import java.util.Iterator;

public abstract class GcmListenerService
extends Service {
    private final Object zzrN = new Object();
    private int zzbfI;
    private int zzbfJ = 0;

    public void onMessageReceived(String string, Bundle bundle) {
    }

    public void onDeletedMessages() {
    }

    public void onMessageSent(String string) {
    }

    public void onSendError(String string, String string2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int n, int n2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzbfI = n2;
            ++this.zzbfJ;
        }
        if (intent == null) {
            this.zzGa();
            return 2;
        }
        this.zzl(intent);
        return 3;
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    @TargetApi(value=11)
    private void zzl(final Intent intent) {
        if (Build.VERSION.SDK_INT >= 11) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    GcmListenerService.this.zzm(intent);
                }
            });
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... voidArray) {
                    GcmListenerService.this.zzm(intent);
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzm(Intent intent) {
        try {
            switch (intent.getAction()) {
                case "com.google.android.c2dm.intent.RECEIVE": {
                    this.zzn(intent);
                    break;
                }
                default: {
                    String string = String.valueOf(intent.getAction());
                    Log.d((String)"GcmListenerService", (String)(string.length() != 0 ? "Unknown intent action: ".concat(string) : new String("Unknown intent action: ")));
                }
            }
            this.zzGa();
        }
        finally {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void zzn(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                this.zzo(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(this.zzp(intent), intent.getStringExtra("error"));
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                Log.w((String)"GcmListenerService", (String)(string2.length() != 0 ? "Received message with unknown type: ".concat(string2) : new String("Received message with unknown type: ")));
            }
        }
    }

    private void zzo(Intent intent) {
        Bundle bundle = intent.getExtras();
        bundle.remove("message_type");
        bundle.remove("android.support.content.wakelockid");
        if (zza.zzE(bundle)) {
            if (!zza.zzbc((Context)this)) {
                zza.zzbb((Context)this).zzG(bundle);
                return;
            }
            zza.zzF(bundle);
        }
        String string = bundle.getString("from");
        bundle.remove("from");
        GcmListenerService.zzD(bundle);
        this.onMessageReceived(string, bundle);
    }

    private String zzp(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            string = intent.getStringExtra("message_id");
        }
        return string;
    }

    static void zzD(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || !string.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzGa() {
        Object object = this.zzrN;
        synchronized (object) {
            --this.zzbfJ;
            if (this.zzbfJ == 0) {
                this.zzjr(this.zzbfI);
            }
        }
    }

    boolean zzjr(int n) {
        return this.stopSelfResult(n);
    }
}

