/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zzc;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static int zzbgC = 5000000;
    public static int zzbgD = 6500000;
    public static int zzbgE = 7000000;
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    @Deprecated
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    @Deprecated
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    public static final String INSTANCE_ID_SCOPE = "GCM";
    static GoogleCloudMessaging zzbgF;
    private Context zzqn;
    private PendingIntent zzbgG;
    private Map<String, Handler> zzbgH;
    private static final AtomicInteger zzbgI;
    private final BlockingQueue<Intent> zzbgJ = new LinkedBlockingQueue<Intent>();
    final Messenger zzbgK;

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzbgF == null) {
            zzbgF = new GoogleCloudMessaging();
            GoogleCloudMessaging.zzbgF.zzqn = context.getApplicationContext();
        }
        return zzbgF;
    }

    public GoogleCloudMessaging() {
        this.zzbgH = Collections.synchronizedMap(new HashMap());
        this.zzbgK = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                Intent intent;
                if (message == null || !(message.obj instanceof Intent)) {
                    Log.w((String)GoogleCloudMessaging.INSTANCE_ID_SCOPE, (String)"Dropping invalid message");
                }
                if ("com.google.android.c2dm.intent.REGISTRATION".equals((intent = (Intent)message.obj).getAction())) {
                    GoogleCloudMessaging.this.zzbgJ.add(intent);
                } else if (!GoogleCloudMessaging.this.zzn(intent)) {
                    intent.setPackage(GoogleCloudMessaging.this.zzqn.getPackageName());
                    GoogleCloudMessaging.this.zzqn.sendBroadcast(intent);
                }
            }
        });
    }

    public void close() {
        zzbgF = null;
        zza.zzbgn = null;
        this.zzGT();
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string, String string2, Bundle bundle) throws IOException {
        this.send(string, string2, -1L, bundle);
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string, String string2, long l, Bundle bundle) throws IOException {
        this.zza(string, string2, l, -1, bundle);
    }

    private void zza(String string, String string2, long l, int n, Bundle bundle) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        String string3 = zzc.zzbA((Context)this.zzqn);
        if (string3 == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.zzo(intent);
        intent.setPackage(string3);
        intent.putExtra("google.to", string);
        intent.putExtra("google.message_id", string2);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(n));
        intent.putExtra("google.from", this.zzeE(string));
        if (string3.contains(".gsf")) {
            Bundle bundle2 = new Bundle();
            for (String string4 : bundle.keySet()) {
                Object object = bundle.get(string4);
                if (!(object instanceof String)) continue;
                String string5 = String.valueOf(string4);
                bundle2.putString(string5.length() != 0 ? "gcm.".concat(string5) : new String("gcm."), (String)object);
            }
            bundle2.putString("google.to", string);
            bundle2.putString("google.message_id", string2);
            InstanceID.getInstance((Context)this.zzqn).zzc(INSTANCE_ID_SCOPE, "upstream", bundle2);
            return;
        }
        this.zzqn.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private String zzeE(String string) {
        int n = string.indexOf(64);
        String string2 = n > 0 ? string.substring(0, n) : string;
        InstanceID instanceID = InstanceID.getInstance((Context)this.zzqn);
        return instanceID.zzHj().zzh("", string2, INSTANCE_ID_SCOPE);
    }

    private boolean zzn(Intent intent) {
        Handler handler;
        String string = intent.getStringExtra("In-Reply-To");
        if (string == null && intent.hasExtra("error")) {
            string = intent.getStringExtra("google.message_id");
        }
        if (string != null && (handler = this.zzbgH.remove(string)) != null) {
            Message message = Message.obtain();
            message.obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    private String zzGS() {
        String string = String.valueOf("google.rpc");
        String string2 = String.valueOf(String.valueOf(zzbgI.getAndIncrement()));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        InstanceID.getInstance((Context)this.zzqn).deleteInstanceID();
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized String register(String ... stringArray) throws IOException {
        return this.zza(zzc.zzbz((Context)this.zzqn), stringArray);
    }

    @Deprecated
    public synchronized String zza(boolean bl, String ... stringArray) throws IOException {
        String string = zzc.zzbA((Context)this.zzqn);
        if (string == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string2 = this.zzf(stringArray);
        Bundle bundle = new Bundle();
        if (string.contains(".gsf")) {
            bundle.putString("legacy.sender", string2);
            return InstanceID.getInstance((Context)this.zzqn).getToken(string2, INSTANCE_ID_SCOPE, bundle);
        }
        bundle.putString("sender", string2);
        Intent intent = this.zza(bundle, bl);
        return GoogleCloudMessaging.zza(intent, "registration_id");
    }

    @Deprecated
    Intent zza(Bundle bundle, boolean bl) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        int n = GoogleCloudMessaging.zzbv(this.zzqn);
        if (n < 0) {
            throw new IOException("Google Play Services missing");
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intent intent = new Intent(bl ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzc.zzbA((Context)this.zzqn));
        this.zzo(intent);
        String string = this.zzGS();
        intent.putExtra("google.message_id", string);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzbgK);
        if (bl) {
            this.zzqn.sendBroadcast(intent);
        } else {
            this.zzqn.startService(intent);
        }
        try {
            Intent intent2 = this.zzbgJ.poll(30000L, TimeUnit.MILLISECONDS);
            return intent2;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    static String zza(Intent intent, String string) throws IOException {
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string2 = intent.getStringExtra(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = intent.getStringExtra("error");
        if (string3 != null) {
            throw new IOException(string3);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    String zzf(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            return null;
        }
        String string2 = intent.getStringExtra("message_type");
        if (string2 != null) {
            return string2;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void zzo(Intent intent) {
        if (this.zzbgG == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbgG = PendingIntent.getBroadcast((Context)this.zzqn, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbgG);
    }

    synchronized void zzGT() {
        if (this.zzbgG != null) {
            this.zzbgG.cancel();
            this.zzbgG = null;
        }
    }

    public static int zzbv(Context context) {
        String string = zzc.zzbA((Context)context);
        if (string != null) {
            try {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
                if (packageInfo != null) {
                    return packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return -1;
    }

    static {
        zzbgI = new AtomicInteger(1);
    }
}

