/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.firebase.iid.zzh;

public class GcmReceiver
extends WakefulBroadcastReceiver {
    private static String zzbfA = "gcm.googleapis.com/refresh";
    private static boolean zzbfB = false;
    private zzh zzbfC;
    private zzh zzbfD;

    public void onReceive(Context context, Intent intent) {
        String string;
        String string2;
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            Log.d((String)"GcmReceiver", (String)"received new intent");
        }
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ("google.com/iid".equals(string2 = intent.getStringExtra("from")) || zzbfA.equals(string2)) {
            intent.setAction("com.google.android.gms.iid.InstanceID");
        }
        if ((string = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        if (zzq.isAtLeastO()) {
            if (this.isOrderedBroadcast()) {
                this.setResultCode(-1);
            }
            this.zzH(context, intent.getAction()).zza(intent, this.goAsync());
            return;
        }
        if ("com.google.android.c2dm.intent.RECEIVE".equals(intent.getAction())) {
            Intent intent2 = intent;
            Context context2 = context;
            this.doStartService(context2, intent2);
        } else {
            this.doStartService(context, intent);
        }
        if (this.isOrderedBroadcast() && this.getResultCode() == 0) {
            this.setResultCode(-1);
        }
    }

    private final synchronized zzh zzH(Context context, String string) {
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            if (this.zzbfD == null) {
                this.zzbfD = new zzh(context, string);
            }
            return this.zzbfD;
        }
        if (this.zzbfC == null) {
            this.zzbfC = new zzh(context, string);
        }
        return this.zzbfC;
    }

    private final void doStartService(Context context, Intent intent) {
        if (this.isOrderedBroadcast()) {
            this.setResultCode(500);
        }
        Intent intent2 = intent;
        Context context2 = context;
        ResolveInfo resolveInfo = context2.getPackageManager().resolveService(intent2, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"GcmReceiver", (String)"Failed to resolve target intent service, skipping classname enforcement");
        } else {
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!context2.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
                String string = String.valueOf(serviceInfo.packageName);
                String string2 = String.valueOf(serviceInfo.name);
                Log.e((String)"GcmReceiver", (String)new StringBuilder(94 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string).append("/").append(string2).toString());
            } else {
                String string;
                String string3 = serviceInfo.name;
                if (string3.startsWith(".")) {
                    String string4 = String.valueOf(context2.getPackageName());
                    String string5 = String.valueOf(string3);
                    string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                } else {
                    string = string3 = string3;
                }
                if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
                    String string6 = String.valueOf(string3);
                    Log.d((String)"GcmReceiver", (String)(string6.length() != 0 ? "Restricting intent to a specific service: ".concat(string6) : new String("Restricting intent to a specific service: ")));
                }
                intent2.setClassName(context2.getPackageName(), string3);
            }
        }
        try {
            ComponentName componentName;
            if (context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
                componentName = GcmReceiver.startWakefulService((Context)context, (Intent)intent);
            } else {
                componentName = context.startService(intent);
                Log.d((String)"GcmReceiver", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"GcmReceiver", (String)"Error while delivering the message: ServiceIntent not found.");
                if (this.isOrderedBroadcast()) {
                    this.setResultCode(404);
                    return;
                }
            } else if (this.isOrderedBroadcast()) {
                this.setResultCode(-1);
            }
            return;
        }
        catch (SecurityException securityException) {
            Log.e((String)"GcmReceiver", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            if (this.isOrderedBroadcast()) {
                this.setResultCode(401);
            }
            return;
        }
    }
}

