/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzi;

public class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzide;
    private final String mTag;
    private final boolean zzidf;
    private final boolean zzidg;
    private final int zzidh;
    private final boolean zzidi;
    private final boolean zzidj;
    private final zzi zzidk;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzide = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzidf = builder.updateCurrent;
        this.zzidg = builder.isPersisted;
        this.zzidh = builder.requiredNetworkState;
        this.zzidi = builder.requiresCharging;
        this.zzidj = false;
        this.mExtras = builder.extras;
        this.zzidk = builder.zzidl != null ? builder.zzidl : zzi.zzicz;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzide = parcel.readString();
        this.mTag = parcel.readString();
        this.zzidf = parcel.readInt() == 1;
        this.zzidg = parcel.readInt() == 1;
        this.zzidh = 2;
        this.zzidi = false;
        this.zzidj = false;
        this.zzidk = zzi.zzicz;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzidf);
        bundle.putBoolean("persisted", this.zzidg);
        bundle.putString("service", this.zzide);
        bundle.putInt("requiredNetwork", this.zzidh);
        bundle.putBoolean("requiresCharging", this.zzidi);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zzidk.zzu(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzide;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzidf;
    }

    public boolean isPersisted() {
        return this.zzidg;
    }

    public int getRequiredNetwork() {
        return this.zzidh;
    }

    public boolean getRequiresCharging() {
        return this.zzidi;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zzide);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzidf ? 1 : 0);
        parcel.writeInt(this.zzidg ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zzv(Bundle bundle) {
        if (bundle != null) {
            Object object = bundle;
            Parcel parcel = Parcel.obtain();
            object.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            parcel.recycle();
            int n2 = n;
            if (n2 > 10240) {
                String string2 = "Extras exceeding maximum size(10240 bytes): ";
                throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString());
            }
            for (String string3 : bundle.keySet()) {
                Object object2 = bundle.get(string3);
                object = object2;
                if (object2 instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean) continue;
                if (object2 instanceof Bundle) {
                    Task.zzv((Bundle)object2);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzi zzidl = zzi.zzicz;
        protected Bundle extras;

        public Builder() {
        }

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzbq.checkArgument((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzhv(this.tag);
            zzi zzi2 = this.zzidl;
            if (zzi2 != null) {
                int n = zzi2.zzaux();
                if (n != 1 && n != 0) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
                }
                int n2 = zzi2.zzauy();
                int n3 = zzi2.zzauz();
                if (n == 0 && n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
                }
                if (n == 1 && n2 < 10) {
                    throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
                }
                if (n3 < n2) {
                    int n4 = zzi2.zzauz();
                    throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
                }
            }
            if (this.isPersisted) {
                Task.zzv(this.extras);
            }
        }
    }
}

