/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzd;
import com.google.android.gms.gcm.zze;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Object zza = new Object();
    private int zzb;
    private ExecutorService zzc;
    private Messenger zzd;
    private ComponentName zze;
    private GcmNetworkManager zzf;

    public GcmTaskService() {
    }

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzf = GcmNetworkManager.getInstance((Context)this);
        GcmTaskService gcmTaskService = this;
        this.zzc = Executors.newFixedThreadPool(2, new com.google.android.gms.gcm.zzb(gcmTaskService));
        this.zzd = new Messenger((Handler)new zza(this, Looper.getMainLooper()));
        this.zze = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
    }

    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        List<Runnable> list = this.zzc.shutdownNow();
        if (!list.isEmpty()) {
            int n = list.size();
            Log.e((String)"GcmTaskService", (String)new StringBuilder(79).append("Shutting down, but not all tasks are finished executing. Remaining: ").append(n).toString());
        }
    }

    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent == null) {
            this.zza(n2);
            return 2;
        }
        try {
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string2 = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string2)) {
                String string3 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = intent.getBundleExtra("extras");
                ArrayList arrayList = intent.getParcelableArrayListExtra("triggered_uris");
                if (!(parcelable instanceof PendingCallback)) {
                    String string4 = this.getPackageName();
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append(" ").append(string3).append(": Could not process request, invalid callback.").toString());
                    return 2;
                }
                if (this.zza(string3)) {
                    return 2;
                }
                IBinder iBinder = ((PendingCallback)parcelable).zza;
                zzb zzb2 = new zzb(this, string3, iBinder, bundle, (List<Uri>)arrayList);
                this.zza(zzb2);
            } else if (SERVICE_ACTION_INITIALIZE.equals(string2)) {
                this.onInitializeTasks();
            } else {
                Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string2).length()).append("Unknown action received ").append(string2).append(", terminating").toString());
            }
            return 2;
        }
        finally {
            this.zza(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    private final boolean zza(String string2) {
        Object object = this.zza;
        synchronized (object) {
            boolean bl = !this.zzf.zza(string2, this.zze.getClassName());
            if (bl) {
                String string3 = this.getPackageName();
                Log.w((String)"GcmTaskService", (String)new StringBuilder(44 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Task already running, won't start another").toString());
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n) {
        Object object = this.zza;
        synchronized (object) {
            this.zzb = n;
            if (!this.zzf.zzb(this.zze.getClassName())) {
                this.stopSelf(this.zzb);
            }
            return;
        }
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (intent == null || !zzs.zzg() || !SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            return null;
        }
        return this.zzd.getBinder();
    }

    private final void zza(zzb zzb2) {
        try {
            this.zzc.execute(zzb2);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)"GcmTaskService", (String)"Executor is shutdown. onDestroy was called but main looper had an unprocessed start task message. The task will be retried with backoff delay.", (Throwable)rejectedExecutionException);
            zzb2.zza(1);
            return;
        }
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    final class zzb
    implements Runnable {
        private final String zza;
        private final Bundle zzb;
        private final List<Uri> zzc;
        @Nullable
        private final zzd zzd;
        @Nullable
        private final Messenger zze;
        private /* synthetic */ GcmTaskService zzf;

        zzb(GcmTaskService gcmTaskService, @NonNull String string2, IBinder iBinder, Bundle bundle, List<Uri> list) {
            IInterface iInterface;
            this.zzf = gcmTaskService;
            this.zza = string2;
            IBinder iBinder2 = iBinder;
            this.zzd = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.gcm.INetworkTaskCallback")) instanceof zzd ? (zzd)iInterface : new zze(iBinder2));
            this.zzb = bundle;
            this.zzc = list;
            this.zze = null;
        }

        zzb(GcmTaskService gcmTaskService, @NonNull String string2, Messenger messenger, Bundle bundle, List<Uri> list) {
            this.zzf = gcmTaskService;
            this.zza = string2;
            this.zze = messenger;
            this.zzb = bundle;
            this.zzc = list;
            this.zzd = null;
        }

        @Override
        public final void run() {
            TaskParams taskParams = new TaskParams(this.zza, this.zzb, this.zzc);
            int n = this.zzf.onRunTask(taskParams);
            this.zza(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zza(int n) {
            Object object = this.zzf.zza;
            synchronized (object) {
                try {
                    if (this.zzf.zzf.zzc(this.zza, this.zzf.zze.getClassName())) {
                        return;
                    }
                    if (this.zza()) {
                        int n2 = n;
                        zzb zzb2 = this;
                        Message message = Message.obtain();
                        Message.obtain().what = 3;
                        message.arg1 = n2;
                        Bundle bundle = new Bundle();
                        bundle.putParcelable("component", (Parcelable)zzb2.zzf.zze);
                        bundle.putString("tag", zzb2.zza);
                        message.setData(bundle);
                        this.zze.send(message);
                    } else {
                        this.zzd.zza(n);
                    }
                }
                catch (RemoteException remoteException) {
                    String string2 = String.valueOf(this.zza);
                    Log.e((String)"GcmTaskService", (String)(string2.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string2) : new String("Error reporting result of operation to scheduler for ")));
                }
                finally {
                    this.zzf.zzf.zzb(this.zza, this.zzf.zze.getClassName());
                    if (!this.zza() && !this.zzf.zzf.zzb(this.zzf.zze.getClassName())) {
                        this.zzf.stopSelf(this.zzf.zzb);
                    }
                }
                return;
            }
        }

        private final boolean zza() {
            return this.zze != null;
        }
    }

    @TargetApi(value=21)
    final class zza
    extends Handler {
        private /* synthetic */ GcmTaskService zza;

        zza(GcmTaskService gcmTaskService, Looper looper) {
            this.zza = gcmTaskService;
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (!zzz.zza((Context)this.zza, (int)message.sendingUid, (String)"com.google.android.gms")) {
                Log.e((String)"GcmTaskService", (String)"unable to verify presence of Google Play Services");
                return;
            }
            switch (message.what) {
                case 1: {
                    Messenger messenger;
                    Message message2 = message;
                    zza zza2 = this;
                    Bundle bundle = message2.getData();
                    if (!bundle.isEmpty() && (messenger = message2.replyTo) != null) {
                        String string2 = bundle.getString("tag");
                        ArrayList arrayList = bundle.getParcelableArrayList("triggered_uris");
                        if (!zza2.zza.zza(string2)) {
                            Bundle bundle2 = bundle.getBundle("extras");
                            zzb zzb2 = new zzb(zza2.zza, string2, messenger, bundle2, (List<Uri>)arrayList);
                            zza2.zza.zza(zzb2);
                        }
                    }
                    return;
                }
                case 2: {
                    Message message3 = message;
                    if (Log.isLoggable((String)"GcmTaskService", (int)3)) {
                        String string3 = String.valueOf(message3);
                        Log.d((String)"GcmTaskService", (String)new StringBuilder(45 + String.valueOf(string3).length()).append("ignoring unimplemented stop message for now: ").append(string3).toString());
                    }
                    return;
                }
                case 4: {
                    this.zza.onInitializeTasks();
                    return;
                }
            }
            String string4 = String.valueOf(message);
            Log.e((String)"GcmTaskService", (String)new StringBuilder(31 + String.valueOf(string4).length()).append("Unrecognized message received: ").append(string4).toString());
        }
    }
}

