/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzf;

public class OneoffTask
extends Task {
    private final long zza;
    private final long zzb;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new zzf();

    private OneoffTask(Builder builder) {
        super(builder);
        this.zza = builder.zzb;
        this.zzb = builder.zzc;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zza = parcel.readLong();
        this.zzb = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zza);
        bundle.putLong("window_end", this.zzb);
    }

    public long getWindowStart() {
        return this.zza;
    }

    public long getWindowEnd() {
        return this.zzb;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zza);
        parcel.writeLong(this.zzb);
    }

    public String toString() {
        String string2 = super.toString();
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string2).length()).append(string2).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    /* synthetic */ OneoffTask(Parcel parcel, zzf zzf2) {
        this(parcel);
    }

    /* synthetic */ OneoffTask(Builder builder, zzf zzf2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzb = -1L;
        private long zzc = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzb = l;
            this.zzc = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string2) {
            this.tag = string2;
            return this;
        }

        @Override
        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzb == -1L || this.zzc == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzb >= this.zzc) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            ((Task.Builder)this).checkConditions();
            return new OneoffTask(this, null);
        }
    }
}

