/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzm;
import com.google.android.gms.gcm.zzn;
import com.google.android.gms.gcm.zzo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    @GuardedBy(value="GcmNetworkManager.class")
    private static GcmNetworkManager zzg;
    private final Context zzh;
    @GuardedBy(value="this")
    private final Map<String, Map<String, Boolean>> zzi = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmNetworkManager getInstance(Context context) {
        Class<GcmNetworkManager> clazz = GcmNetworkManager.class;
        synchronized (GcmNetworkManager.class) {
            if (zzg == null) {
                zzg = new GcmNetworkManager(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzg;
        }
    }

    private GcmNetworkManager(Context context) {
        this.zzh = context;
    }

    @NonNull
    private final zzn zzd() {
        if (GoogleCloudMessaging.zzf(this.zzh) < 5000000) {
            Log.e((String)"GcmNetworkManager", (String)"Google Play services is not available, dropping all GcmNetworkManager requests");
            return new zzo();
        }
        return new zzm(this.zzh);
    }

    @WorkerThread
    public synchronized void schedule(Task task) {
        Map<String, Boolean> map;
        this.zze(task.getServiceName());
        if (this.zzd().zzd(task) && (map = this.zzi.get(task.getServiceName())) != null && map.containsKey(task.getTag())) {
            map.put(task.getTag(), true);
        }
    }

    @WorkerThread
    public void cancelTask(String string2, Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.zzh, clazz2);
        String string4 = string3;
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        GcmNetworkManager.zzd(string4);
        gcmNetworkManager2.zze(componentName.getClassName());
        gcmNetworkManager2.zzd().zzd(componentName, string4);
    }

    @WorkerThread
    public void cancelAllTasks(Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.zzh, clazz2);
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        gcmNetworkManager.zze(componentName.getClassName());
        gcmNetworkManager2.zzd().zzd(componentName);
    }

    static void zzd(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string2.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private final boolean zze(String string2) {
        List list;
        List list2;
        Preconditions.checkNotNull((Object)string2, (Object)"GcmTaskService must not be null.");
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        PackageManager packageManager = gcmNetworkManager.zzh.getPackageManager();
        if (packageManager == null) {
            list2 = Collections.emptyList();
        } else {
            String string4 = string3;
            GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
            list2 = list = packageManager.queryIntentServices(string4 != null ? new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setClassName(gcmNetworkManager2.zzh, string4) : new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setPackage(gcmNetworkManager2.zzh.getPackageName()), 0);
        }
        if (CollectionUtils.isEmpty(list2)) {
            Log.e((String)"GcmNetworkManager", (String)String.valueOf(string2).concat(" is not available. This may cause the task to be lost."));
            return true;
        }
        for (ResolveInfo resolveInfo : list) {
            if (resolveInfo.serviceInfo == null || !resolveInfo.serviceInfo.enabled) continue;
            return true;
        }
        throw new IllegalArgumentException(new StringBuilder(118 + String.valueOf(string2).length()).append("The GcmTaskService class you provided ").append(string2).append(" does not seem to support receiving com.google.android.gms.gcm.ACTION_TASK_READY").toString());
    }

    final synchronized boolean zzd(String string2, String string3) {
        ArrayMap arrayMap = this.zzi.get(string3);
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            this.zzi.put(string3, (Map<String, Boolean>)arrayMap);
        }
        return arrayMap.put(string2, false) == null;
    }

    final synchronized void zze(String string2, String string3) {
        Map<String, Boolean> map = this.zzi.get(string3);
        if (map != null && map.remove(string2) != null && map.isEmpty()) {
            this.zzi.remove(string3);
        }
    }

    final synchronized boolean zzf(String string2, String string3) {
        Map<String, Boolean> map = this.zzi.get(string3);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    final synchronized boolean zzf(String string2) {
        return this.zzi.containsKey(string2);
    }
}

