/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String gcmTaskService;
    private final String tag;
    private final boolean updateCurrent;
    private final boolean isPersisted;
    private final int requiredNetworkState;
    private final Set<Uri> zzaw;
    private final boolean requiresCharging;
    private final boolean zzax;
    private final zzl zzay;
    private final Bundle extras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.gcmTaskService = builder.gcmTaskService;
        this.tag = builder.tag;
        this.updateCurrent = builder.updateCurrent;
        this.isPersisted = builder.isPersisted;
        this.requiredNetworkState = builder.requiredNetworkState;
        this.zzaw = builder.zzaw;
        this.requiresCharging = builder.requiresCharging;
        this.zzax = false;
        this.extras = builder.extras;
        this.zzay = builder.zzay != null ? builder.zzay : zzl.zzaq;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.gcmTaskService = parcel.readString();
        this.tag = parcel.readString();
        this.updateCurrent = parcel.readInt() == 1;
        this.isPersisted = parcel.readInt() == 1;
        this.requiredNetworkState = 2;
        this.zzaw = Collections.emptySet();
        this.requiresCharging = false;
        this.zzax = false;
        this.zzay = zzl.zzaq;
        this.extras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.tag);
        bundle.putBoolean("update_current", this.updateCurrent);
        bundle.putBoolean("persisted", this.isPersisted);
        bundle.putString("service", this.gcmTaskService);
        bundle.putInt("requiredNetwork", this.requiredNetworkState);
        if (!this.zzaw.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Uri uri : this.zzaw) {
                arrayList.add(uri.toString());
            }
            bundle.putStringArrayList("reachabilityUris", arrayList);
        }
        bundle.putBoolean("requiresCharging", this.requiresCharging);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zzay.zzf(new Bundle()));
        bundle.putBundle("extras", this.extras);
    }

    public String getServiceName() {
        return this.gcmTaskService;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isUpdateCurrent() {
        return this.updateCurrent;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public int getRequiredNetwork() {
        return this.requiredNetworkState;
    }

    public boolean getRequiresCharging() {
        return this.requiresCharging;
    }

    public Bundle getExtras() {
        return this.extras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.gcmTaskService);
        parcel.writeString(this.tag);
        parcel.writeInt(this.updateCurrent ? 1 : 0);
        parcel.writeInt(this.isPersisted ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zzg(Bundle bundle) {
        if (bundle != null) {
            Object object = bundle;
            Parcel parcel = Parcel.obtain();
            object.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            parcel.recycle();
            int n2 = n;
            if (n2 > 10240) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Extras exceeding maximum size(10240 bytes): ").append(n2).toString());
            }
            for (String string2 : bundle.keySet()) {
                Object object2 = bundle.get(string2);
                object = object2;
                if (object2 instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean) continue;
                if (object2 instanceof Bundle) {
                    Task.zzg((Bundle)object2);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    private static void zzd(Uri uri) {
        int n;
        if (uri == null) {
            throw new IllegalArgumentException("Null URI");
        }
        String string2 = uri.getScheme();
        String string3 = uri.getHost();
        if (TextUtils.isEmpty((CharSequence)string3) || "null".equals(string3)) {
            throw new IllegalArgumentException("URI hostname is required");
        }
        try {
            n = uri.getPort();
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = String.valueOf(numberFormatException.getMessage());
            throw new IllegalArgumentException(string4.length() != 0 ? "Invalid port number: ".concat(string4) : new String("Invalid port number: "));
        }
        if ("tcp".equals(string2)) {
            if (n <= 0 || n > 65535) {
                int n2 = uri.getPort();
                throw new IllegalArgumentException(new StringBuilder(38).append("Invalid required URI port: ").append(n2).toString());
            }
        } else if ("ping".equals(string2)) {
            if (n != -1) {
                throw new IllegalArgumentException("Ping does not support port numbers");
            }
        } else {
            String string5 = String.valueOf(string2);
            throw new IllegalArgumentException(string5.length() != 0 ? "Unsupported required URI scheme: ".concat(string5) : new String("Unsupported required URI scheme: "));
        }
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected Set<Uri> zzaw = Collections.emptySet();
        @ShowFirstParty
        protected zzl zzay = zzl.zzaq;
        protected Bundle extras;

        public Builder() {
        }

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            Preconditions.checkArgument((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzd(this.tag);
            zzl zzl2 = this.zzay;
            if (zzl2 != null) {
                int n = zzl2.zzi();
                if (n != 1 && n != 0) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
                }
                int n2 = zzl2.zzj();
                int n3 = zzl2.zzk();
                if (n == 0 && n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
                }
                if (n == 1 && n2 < 10) {
                    throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
                }
                if (n3 < n2) {
                    int n4 = zzl2.zzk();
                    throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
                }
            }
            if (this.isPersisted) {
                Task.zzg(this.extras);
            }
            if (!this.zzaw.isEmpty() && this.requiredNetworkState == 2) {
                throw new IllegalArgumentException("Required URIs may not be used with NETWORK_STATE_ANY");
            }
            Iterator<Uri> iterator = this.zzaw.iterator();
            while (iterator.hasNext()) {
                Task.zzd(iterator.next());
            }
        }
    }
}

