/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzi;

public class OneoffTask
extends Task {
    private final long zzal;
    private final long zzam;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new zzi();

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzal = builder.zzal;
        this.zzam = builder.zzam;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzal = parcel.readLong();
        this.zzam = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzal);
        bundle.putLong("window_end", this.zzam);
    }

    public long getWindowStart() {
        return this.zzal;
    }

    public long getWindowEnd() {
        return this.zzam;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzal);
        parcel.writeLong(this.zzam);
    }

    public String toString() {
        String string2 = super.toString();
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string2).length()).append(string2).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    /* synthetic */ OneoffTask(Parcel parcel, zzi zzi2) {
        this(parcel);
    }

    /* synthetic */ OneoffTask(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzal = -1L;
        private long zzam = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzal = l;
            this.zzam = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string2) {
            this.tag = string2;
            return this;
        }

        @Override
        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzal == -1L || this.zzam == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzal >= this.zzam) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            ((Task.Builder)this).checkConditions();
            return new OneoffTask(this, null);
        }
    }
}

