/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;

public class InstanceIDListenerService
extends Service {
    static String ACTION = "action";
    MessengerCompat zzaDD = new MessengerCompat(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            InstanceIDListenerService.this.zza(msg, MessengerCompat.zzc(msg));
        }
    });
    BroadcastReceiver zzaDE = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string = intent.getStringExtra("registration_id");
                Log.d((String)"InstanceID", (String)("Received GSF callback using dynamic receiver: " + intent.getExtras()));
            }
            InstanceIDListenerService.this.zzn(intent);
            InstanceIDListenerService.this.stop();
        }
    };
    private static String zzaDF = "google.com/iid";
    private static String zzaDG = "CMD";
    private static String zzaCn = "gcm.googleapis.com/refresh";
    int zzaDH;
    int zzaDI;

    public void zzn(Intent intent) {
        Object object;
        String string = intent.getStringExtra("subtype");
        InstanceID instanceID = null;
        if (string == null) {
            instanceID = InstanceID.getInstance((Context)this);
        } else {
            object = new Bundle();
            object.putString("subtype", string);
            instanceID = InstanceID.zza((Context)this, object);
        }
        object = intent.getStringExtra(zzaDG);
        if (null != intent.getStringExtra("error") || null != intent.getStringExtra("registration_id")) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Register result in service " + string));
            }
            instanceID.zzwp().zzr(intent);
            return;
        }
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            Log.d((String)"InstanceID", (String)("Service command " + string + " " + (String)object + " " + intent.getExtras()));
        }
        if (null != intent.getStringExtra("unregistered")) {
            instanceID.zzwo().zzds(string == null ? "" : string);
            instanceID.zzwp().zzr(intent);
            return;
        }
        if (zzaCn.equals(intent.getStringExtra("from"))) {
            instanceID.zzwo().zzds(string);
            this.zzag(false);
            return;
        }
        if ("RST".equals(object)) {
            instanceID.zzwn();
            this.zzag(true);
        } else if ("RST_FULL".equals(object)) {
            if (!instanceID.zzwo().isEmpty()) {
                instanceID.zzwo().zzwt();
                this.zzag(true);
            }
        } else if ("SYNC".equals(object)) {
            instanceID.zzwo().zzds(string);
            this.zzag(false);
        } else if ("PING".equals(object)) {
            try {
                GoogleCloudMessaging.getInstance((Context)this).send(zzaDF, zzc.zzws(), 0L, intent.getExtras());
            }
            catch (IOException iOException) {
                Log.w((String)"InstanceID", (String)"Failed to send ping response");
            }
        }
    }

    static void zza(Context context, zzd zzd2) {
        zzd2.zzwt();
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.putExtra(zzaDG, "RST");
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }

    static void zzaD(Context context) {
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.setPackage(context.getPackageName());
        intent.putExtra(zzaDG, "SYNC");
        context.startService(intent);
    }

    private void zza(Message message, int n) {
        zzc.zzaE((Context)this);
        PackageManager packageManager = this.getPackageManager();
        if (n != zzc.zzaDP && n != zzc.zzaDO) {
            Log.w((String)"InstanceID", (String)("Message from unexpected caller " + n + " mine=" + zzc.zzaDO + " appid=" + zzc.zzaDP));
            return;
        }
        this.zzn((Intent)message.obj);
    }

    public void onCreate() {
        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
        intentFilter.addCategory(this.getPackageName());
        this.registerReceiver(this.zzaDE, intentFilter, "com.google.android.c2dm.permission.RECEIVE", null);
    }

    public void onDestroy() {
        this.unregisterReceiver(this.zzaDE);
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && "com.google.android.gms.iid.InstanceID".equals(intent.getAction())) {
            return this.zzaDD.getBinder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            --this.zzaDH;
            if (this.zzaDH == 0) {
                this.stopSelf(this.zzaDI);
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Stop " + this.zzaDH + " " + this.zzaDI));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzgI(int n) {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            ++this.zzaDH;
            if (n > this.zzaDI) {
                this.zzaDI = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzgI(startId);
        if (intent == null) {
            this.stop();
            return 2;
        }
        try {
            String string = intent.getAction();
            if ("com.google.android.gms.iid.InstanceID".equals(string)) {
                Intent intent2;
                if (Build.VERSION.SDK_INT <= 18 && (intent2 = (Intent)intent.getParcelableExtra("GSF")) != null) {
                    this.startService(intent2);
                    int n = 1;
                    return n;
                }
                this.zzn(intent);
            }
        }
        finally {
            this.stop();
        }
        if (intent.getStringExtra("from") != null) {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
        return 2;
    }

    public void zzag(boolean bl) {
        this.onTokenRefresh();
    }

    public void onTokenRefresh() {
    }
}

