/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.iid.zzb;

public class MessengerCompat
implements Parcelable {
    Messenger zzaDK;
    zzb zzaDL;
    public static final Parcelable.Creator<MessengerCompat> CREATOR = new Parcelable.Creator<MessengerCompat>(){

        public MessengerCompat zzey(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            return iBinder != null ? new MessengerCompat(iBinder) : null;
        }

        public MessengerCompat[] zzgJ(int n) {
            return new MessengerCompat[n];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.zzgJ(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzey(x0);
        }
    };

    public MessengerCompat(Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzaDK = new Messenger(handler);
        } else {
            this.zzaDL = new zza(handler);
        }
    }

    public MessengerCompat(IBinder target) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzaDK = new Messenger(target);
        } else {
            this.zzaDL = zzb.zza.zzbV(target);
        }
    }

    public static int zzc(Message message) {
        if (Build.VERSION.SDK_INT >= 21) {
            return MessengerCompat.zzd(message);
        }
        return message.arg2;
    }

    private static int zzd(Message message) {
        return message.sendingUid;
    }

    public void send(Message message) throws RemoteException {
        if (this.zzaDK != null) {
            this.zzaDK.send(message);
        } else {
            this.zzaDL.send(message);
        }
    }

    public IBinder getBinder() {
        return this.zzaDK != null ? this.zzaDK.getBinder() : this.zzaDL.asBinder();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((MessengerCompat)otherObj).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (this.zzaDK != null) {
            out.writeStrongBinder(this.zzaDK.getBinder());
        } else {
            out.writeStrongBinder(this.zzaDL.asBinder());
        }
    }

    private final class zza
    extends zzb.zza {
        Handler handler;

        zza(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void send(Message msg) throws RemoteException {
            msg.arg2 = Binder.getCallingUid();
            this.handler.dispatchMessage(msg);
        }
    }
}

