/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.gcm.zzb;

public abstract class GcmListenerService
extends Service {
    private final Object zzpK = new Object();
    private int zzaII;
    private int zzaIJ = 0;
    private static boolean zzaIK = false;

    public void onMessageReceived(String from, Bundle data) {
    }

    public void onDeletedMessages() {
    }

    public void onMessageSent(String msgId) {
    }

    public void onSendError(String msgId, String error) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int flags, int startId) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzaII = startId;
            ++this.zzaIJ;
        }
        if ("com.google.android.gms.gcm.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.zzm(intent);
            this.zzxv();
            GcmReceiver.completeWakefulIntent((Intent)intent);
        } else {
            this.zzn(intent);
        }
        return 3;
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    private void zzm(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("com.google.android.gms.gcm.PENDING_INTENT");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"GcmListenerService", (String)"Notification pending intent canceled");
            }
        }
        zza.zzf((Context)this, intent);
    }

    private void zzn(final Intent intent) {
        if (Build.VERSION.SDK_INT >= 11) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    GcmListenerService.this.zzo(intent);
                }
            });
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void zzb(Void ... voidArray) {
                    GcmListenerService.this.zzo(intent);
                    return null;
                }

                protected /* synthetic */ Object doInBackground(Object[] x0) {
                    return this.zzb((Void[])x0);
                }
            }.execute((Object[])new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzo(Intent intent) {
        try {
            switch (intent.getAction()) {
                case "com.google.android.c2dm.intent.RECEIVE": {
                    this.zzp(intent);
                    break;
                }
                case "com.google.android.gms.gcm.NOTIFICATION_DISMISS": {
                    zza.zzg((Context)this, intent);
                    break;
                }
                default: {
                    Log.d((String)"GcmListenerService", (String)("Unknown intent action: " + intent.getAction()));
                }
            }
            this.zzxv();
        }
        finally {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void zzp(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                if (GcmListenerService.zzr(intent)) {
                    zza.zze((Context)this, intent);
                }
                this.zzq(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(intent.getStringExtra("google.message_id"), intent.getStringExtra("error"));
                break;
            }
            default: {
                Log.w((String)"GcmListenerService", (String)("Received message with unknown type: " + string));
            }
        }
    }

    private void zzq(Intent intent) {
        Bundle bundle = intent.getExtras();
        bundle.remove("message_type");
        bundle.remove("android.support.content.wakelockid");
        if (zzb.zzx(bundle)) {
            if (!zzb.zzaH((Context)this)) {
                zzb.zzc((Context)this, ((Object)((Object)this)).getClass()).zzz(bundle);
                return;
            }
            zzb.zzy(bundle);
            if (GcmListenerService.zzr(intent)) {
                zza.zzh((Context)this, intent);
            }
        }
        String string = bundle.getString("from");
        bundle.remove("from");
        this.onMessageReceived(string, bundle);
    }

    static boolean zzr(Intent intent) {
        return zzaIK && !TextUtils.isEmpty((CharSequence)intent.getStringExtra("gcm.a.campaign"));
    }

    static boolean zzw(Bundle bundle) {
        return zzaIK && !TextUtils.isEmpty((CharSequence)bundle.getString("gcm.a.campaign"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzxv() {
        Object object = this.zzpK;
        synchronized (object) {
            --this.zzaIJ;
            if (this.zzaIJ == 0) {
                this.zzgU(this.zzaII);
            }
        }
    }

    boolean zzgU(int n) {
        return this.stopSelfResult(n);
    }
}

