/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long zzaJi;
    private final long zzaJj;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzez(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zzgW(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.zzgW(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzez(x0);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzaJi = builder.zzaJk;
        this.zzaJj = builder.zzaJl;
    }

    @Deprecated
    private OneoffTask(Parcel in) {
        super(in);
        this.zzaJi = in.readLong();
        this.zzaJj = in.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzaJi);
        bundle.putLong("window_end", this.zzaJj);
    }

    public long getWindowStart() {
        return this.zzaJi;
    }

    public long getWindowEnd() {
        return this.zzaJj;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.zzaJi);
        parcel.writeLong(this.zzaJj);
    }

    public String toString() {
        return super.toString() + " " + "windowStart=" + this.getWindowStart() + " " + "windowEnd=" + this.getWindowEnd();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaJk = -1L;
        private long zzaJl = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long windowStartDelaySeconds, long windowEndDelaySeconds) {
            this.zzaJk = windowStartDelaySeconds;
            this.zzaJl = windowEndDelaySeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaJk == -1L || this.zzaJl == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzaJk >= this.zzaJl) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

