/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new Parcelable.Creator<PeriodicTask>(){

        public PeriodicTask zzeB(Parcel parcel) {
            return new PeriodicTask(parcel);
        }

        public PeriodicTask[] zzgY(int n) {
            return new PeriodicTask[n];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.zzgY(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzeB(x0);
        }
    };

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzaJm;
        this.mFlexInSeconds = Math.min(builder.zzaJn, this.mIntervalInSeconds);
    }

    @Deprecated
    private PeriodicTask(Parcel in) {
        super(in);
        this.mIntervalInSeconds = in.readLong();
        this.mFlexInSeconds = Math.min(in.readLong(), this.mIntervalInSeconds);
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public String toString() {
        return super.toString() + " " + "period=" + this.getPeriod() + " " + "flex=" + this.getFlex();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaJm = -1L;
        private long zzaJn = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long periodInSeconds) {
            this.zzaJm = periodInSeconds;
            return this;
        }

        public Builder setFlex(long flexInSeconds) {
            this.zzaJn = flexInSeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        @Override
        public PeriodicTask build() {
            this.checkConditions();
            return new PeriodicTask(this);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaJm == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzaJm <= 0L) {
                throw new IllegalArgumentException("Period set cannot be less or equal to 0: " + this.zzaJm);
            }
            if (this.zzaJn == -1L) {
                this.zzaJn = (long)((float)this.zzaJm * 0.1f);
            } else if (this.zzaJn > this.zzaJm) {
                this.zzaJn = this.zzaJm;
            }
        }
    }
}

