/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GcmListenerService;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

class zzb {
    static zzb zzaIN;
    private final Context mContext;
    private final Class<? extends GcmListenerService> zzaIO;

    static synchronized zzb zzc(Context context, Class<? extends GcmListenerService> clazz) {
        if (zzaIN == null) {
            zzaIN = new zzb(context, clazz);
        }
        return zzaIN;
    }

    static boolean zzx(Bundle bundle) {
        return zzb.zzc(bundle, "gcm.n.icon") != null;
    }

    static boolean zzaH(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            return false;
        }
        int n = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static void zzy(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            if (string2.startsWith("gcm.n.")) {
                string = string2.substring("gcm.n.".length());
                bundle2.putString(string, bundle.getString(string2));
                iterator.remove();
                continue;
            }
            if (!string2.startsWith("gcm.notification.")) continue;
            string = string2.substring("gcm.notification.".length());
            bundle2.putString(string, bundle.getString(string2));
            iterator.remove();
        }
        if (!bundle2.isEmpty()) {
            bundle.putBundle("notification", bundle2);
        }
    }

    static String zzc(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    private zzb(Context context, Class<? extends GcmListenerService> clazz) {
        this.mContext = context.getApplicationContext();
        this.zzaIO = clazz;
    }

    boolean zzz(Bundle bundle) {
        try {
            Notification notification = this.zzA(bundle);
            this.zza(zzb.zzc(bundle, "gcm.n.tag"), notification);
            return true;
        }
        catch (zza zza2) {
            Log.w((String)"GcmNotification", (String)("Failed to show notification: " + zza2.getMessage()));
            return false;
        }
    }

    private Notification zzA(Bundle bundle) {
        String string = this.zzd(bundle, "gcm.n.title");
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new zza("Missing title");
        }
        String string2 = this.zzd(bundle, "gcm.n.body");
        int n = this.zzdH(zzb.zzc(bundle, "gcm.n.icon"));
        String string3 = zzb.zzc(bundle, "gcm.n.color");
        Uri uri = this.zzdI(zzb.zzc(bundle, "gcm.n.sound"));
        PendingIntent pendingIntent = this.zzB(bundle);
        PendingIntent pendingIntent2 = null;
        if (GcmListenerService.zzw(bundle)) {
            pendingIntent = this.zza(bundle, pendingIntent);
            pendingIntent2 = this.zzC(bundle);
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n).setContentTitle((CharSequence)string).setContentText((CharSequence)string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            builder.setColor(Color.parseColor((String)string3));
        }
        if (uri != null) {
            builder.setSound(uri);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent2);
        }
        return builder.build();
    }

    private void zza(String string, Notification notification) {
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "GCM-Notification:" + SystemClock.uptimeMillis();
        }
        notificationManager.notify(string, 0, notification);
    }

    private String zzd(Bundle bundle, String string) {
        JSONArray jSONArray;
        String string2 = zzb.zzc(bundle, string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        String string3 = zzb.zzc(bundle, string + "_loc_key");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string3, "string", this.mContext.getPackageName());
        if (n == 0) {
            throw new zza(this.zzdG(string + "_loc_key") + " resource not found: " + string3);
        }
        String string4 = zzb.zzc(bundle, string + "_loc_args");
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return resources.getString(n);
        }
        try {
            jSONArray = new JSONArray(string4);
        }
        catch (JSONException jSONException) {
            throw new zza("Malformed " + this.zzdG(string + "_loc_args") + ": " + string4);
        }
        Object[] objectArray = new String[jSONArray.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = jSONArray.opt(i);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            throw new zza("Missing format argument for " + string3 + ": " + missingFormatArgumentException);
        }
    }

    private String zzdG(String string) {
        return string.substring("gcm.n.".length());
    }

    private int zzdH(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new zza("Missing icon");
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string, "drawable", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        n = resources.getIdentifier(string, "mipmap", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        throw new zza("Icon resource not found: " + string);
    }

    private Uri zzdI(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if ("default".equals(string)) {
            return RingtoneManager.getDefaultUri((int)2);
        }
        throw new zza("Invalid sound: " + string);
    }

    private PendingIntent zzB(Bundle bundle) {
        String string = zzb.zzc(bundle, "gcm.n.click_action");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Intent intent = new Intent(string);
        intent.setPackage(this.mContext.getPackageName());
        intent.setFlags(0x10000000);
        intent.putExtras(bundle);
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("gcm.n.") && !string2.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string2);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzxx(), (Intent)intent, (int)0x40000000);
    }

    private PendingIntent zza(Bundle bundle, PendingIntent pendingIntent) {
        Intent intent = new Intent("com.google.android.gms.gcm.NOTIFICATION_OPEN");
        this.zza(intent, bundle);
        intent.putExtra("com.google.android.gms.gcm.PENDING_INTENT", (Parcelable)pendingIntent);
        return PendingIntent.getService((Context)this.mContext, (int)this.zzxx(), (Intent)intent, (int)0x40000000);
    }

    private PendingIntent zzC(Bundle bundle) {
        Intent intent = new Intent("com.google.android.gms.gcm.NOTIFICATION_DISMISS");
        this.zza(intent, bundle);
        return PendingIntent.getService((Context)this.mContext, (int)this.zzxx(), (Intent)intent, (int)0x40000000);
    }

    private void zza(Intent intent, Bundle bundle) {
        intent.setClass(this.mContext, this.zzaIO);
        for (String string : bundle.keySet()) {
            if (!string.startsWith("gcm.a.") && !string.equals("from")) continue;
            intent.putExtra(string, bundle.getString(string));
        }
    }

    private int zzxx() {
        return (int)SystemClock.uptimeMillis();
    }

    private class zza
    extends IllegalArgumentException {
        private zza(String string) {
            super(string);
        }
    }
}

