/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzc;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzaTr;
    private final String mTag;
    private final boolean zzaTs;
    private final boolean zzaTt;
    private final int zzaTu;
    private final boolean zzaTv;
    private final zzc zzaTw;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzaTr = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzaTs = builder.updateCurrent;
        this.zzaTt = builder.isPersisted;
        this.zzaTu = builder.requiredNetworkState;
        this.zzaTv = builder.requiresCharging;
        this.mExtras = builder.extras;
        this.zzaTw = builder.zzaTx != null ? builder.zzaTx : zzc.zzaTm;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzaTr = parcel.readString();
        this.mTag = parcel.readString();
        this.zzaTs = parcel.readInt() == 1;
        this.zzaTt = parcel.readInt() == 1;
        this.zzaTu = 2;
        this.zzaTv = false;
        this.zzaTw = zzc.zzaTm;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzaTs);
        bundle.putBoolean("persisted", this.zzaTt);
        bundle.putString("service", this.zzaTr);
        bundle.putInt("requiredNetwork", this.zzaTu);
        bundle.putBoolean("requiresCharging", this.zzaTv);
        bundle.putBundle("retryStrategy", this.zzaTw.zzG(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzaTr;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzaTs;
    }

    public boolean isPersisted() {
        return this.zzaTt;
    }

    public int getRequiredNetwork() {
        return this.zzaTu;
    }

    public boolean getRequiresCharging() {
        return this.zzaTv;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zzaTr);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzaTs ? 1 : 0);
        parcel.writeInt(this.zzaTt ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zza(zzc zzc2) {
        if (zzc2 != null) {
            int n = zzc2.zzBQ();
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
            }
            int n2 = zzc2.zzBR();
            int n3 = zzc2.zzBS();
            if (n == 0 && n2 < 0) {
                throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
            }
            if (n == 1 && n2 < 10) {
                throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
            }
            if (n3 < n2) {
                int n4 = zzc2.zzBS();
                throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
            }
        }
    }

    public static void zzH(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                String string = String.valueOf("Extras exceeding maximum size(10240 bytes): ");
                throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                if (Task.zzE(bundle.get(string))) continue;
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, and Boolean. ");
            }
        }
    }

    private static boolean zzE(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzc zzaTx = zzc.zzaTm;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzaa.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzeu(this.tag);
            Task.zza(this.zzaTx);
            if (this.isPersisted) {
                Task.zzH(this.extras);
            }
        }
    }
}

