/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zzaqp;
import com.google.android.gms.internal.zzaqq;

public class zzaqo
extends zzl<zzaqq> {
    private Activity mActivity;
    private zza zzbht;
    private final String zzaiu;
    private final int mTheme;

    public zzaqo(Activity activity, Looper looper, zzg zzg2, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super((Context)activity, looper, 12, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaiu = zzg2.getAccountName();
        this.mActivity = activity;
        this.mTheme = n;
    }

    public boolean zzxE() {
        return true;
    }

    protected String zzez() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String zzeA() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zzaqq zzcW(IBinder iBinder) {
        return zzaqq.zza.zzcY(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.zzbht != null) {
            this.zzbht.setActivity(null);
            this.zzbht = null;
        }
    }

    protected zzaqq zzHd() throws DeadObjectException {
        return (zzaqq)super.zzxD();
    }

    protected void zzHe() {
        super.zzxC();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzHe();
        this.zzbht = new zza(n, this.mActivity);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzaiu)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzaiu, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzHd().zza(this.zzbht, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzbht.zzj(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzcW(iBinder);
    }

    public static final class zza
    extends zzaqp.zza {
        private final int zzazu;
        private Activity mActivity;

        public zza(int n, Activity activity) {
            this.zzazu = n;
            this.mActivity = activity;
        }

        @Override
        public void zzj(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.mActivity.createPendingResult(this.zzazu, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.mActivity, this.zzazu);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.mActivity.createPendingResult(this.zzazu, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
        }
    }
}

