/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;

public class InstanceIDListenerService
extends Service {
    static String ACTION = "action";
    MessengerCompat zzbhh = new MessengerCompat(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            InstanceIDListenerService.this.zza(message, MessengerCompat.zzc((Message)message));
        }
    });
    BroadcastReceiver zzbhi = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                intent.getStringExtra("registration_id");
                String string = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID", (String)new StringBuilder(46 + String.valueOf(string).length()).append("Received GSF callback using dynamic receiver: ").append(string).toString());
            }
            InstanceIDListenerService.this.zzn(intent);
            InstanceIDListenerService.this.stop();
        }
    };
    private static String zzbhj = "google.com/iid";
    private static String zzbhk = "CMD";
    private static String zzbfQ = "gcm.googleapis.com/refresh";
    int zzbhl;
    int zzbhm;

    public void zzn(Intent intent) {
        Object object;
        InstanceID instanceID;
        String string = intent.getStringExtra("subtype");
        if (string == null) {
            instanceID = InstanceID.getInstance((Context)this);
        } else {
            object = new Bundle();
            object.putString("subtype", string);
            instanceID = InstanceID.zza((Context)this, object);
        }
        object = intent.getStringExtra(zzbhk);
        if (null != intent.getStringExtra("error") || null != intent.getStringExtra("registration_id")) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"InstanceID", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            instanceID.zzGw().zzv(intent);
            return;
        }
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"InstanceID", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(object).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append((String)object).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            instanceID.zzGv().zzeO(string == null ? "" : string);
            instanceID.zzGw().zzv(intent);
            return;
        }
        if (zzbfQ.equals(intent.getStringExtra("from"))) {
            instanceID.zzGv().zzeO(string);
            this.zzaB(false);
            return;
        }
        if ("RST".equals(object)) {
            instanceID.zzGu();
            this.zzaB(true);
        } else if ("RST_FULL".equals(object)) {
            if (!instanceID.zzGv().isEmpty()) {
                instanceID.zzGv().zzGA();
                this.zzaB(true);
            }
        } else if ("SYNC".equals(object)) {
            instanceID.zzGv().zzeO(string);
            this.zzaB(false);
        } else {
            "PING".equals(object);
        }
    }

    static void zza(Context context, zzd zzd2) {
        zzd2.zzGA();
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.putExtra(zzbhk, "RST");
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }

    static void zzbh(Context context) {
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.setPackage(context.getPackageName());
        intent.putExtra(zzbhk, "SYNC");
        context.startService(intent);
    }

    private void zza(Message message, int n) {
        zzc.zzbi((Context)this);
        this.getPackageManager();
        if (n != zzc.zzbhs && n != zzc.zzbhr) {
            int n2 = zzc.zzbhr;
            int n3 = zzc.zzbhs;
            Log.w((String)"InstanceID", (String)new StringBuilder(77).append("Message from unexpected caller ").append(n).append(" mine=").append(n2).append(" appid=").append(n3).toString());
            return;
        }
        this.zzn((Intent)message.obj);
    }

    public void onCreate() {
        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
        intentFilter.addCategory(this.getPackageName());
        this.registerReceiver(this.zzbhi, intentFilter, "com.google.android.c2dm.permission.RECEIVE", null);
    }

    public void onDestroy() {
        this.unregisterReceiver(this.zzbhi);
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && "com.google.android.gms.iid.InstanceID".equals(intent.getAction())) {
            return this.zzbhh.getBinder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            --this.zzbhl;
            if (this.zzbhl == 0) {
                this.stopSelf(this.zzbhm);
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                int n = this.zzbhl;
                int n2 = this.zzbhm;
                Log.d((String)"InstanceID", (String)new StringBuilder(28).append("Stop ").append(n).append(" ").append(n2).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzjA(int n) {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            ++this.zzbhl;
            if (n > this.zzbhm) {
                this.zzbhm = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzjA(n2);
        if (intent == null) {
            this.stop();
            return 2;
        }
        try {
            String string = intent.getAction();
            if ("com.google.android.gms.iid.InstanceID".equals(string)) {
                Intent intent2;
                if (Build.VERSION.SDK_INT <= 18 && (intent2 = (Intent)intent.getParcelableExtra("GSF")) != null) {
                    this.startService(intent2);
                    return 1;
                }
                this.zzn(intent);
            }
        }
        finally {
            this.stop();
        }
        if (intent.getStringExtra("from") != null) {
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
        return 2;
    }

    public void zzaB(boolean bl) {
        this.onTokenRefresh();
    }

    public void onTokenRefresh() {
    }
}

