/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.iid.zzl;
import com.google.android.gms.iid.zzo;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_BACKOFF = "RETRY_LATER";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    private static Map<String, InstanceID> zzifg = new ArrayMap();
    private Context mContext;
    private static zzo zzifh;
    private static zzl zzifi;
    private KeyPair zzifj;
    private String zzifk = "";
    private long zzifl;
    private static String zzifm;

    private InstanceID(Context context, String string, Bundle bundle) {
        this.mContext = context.getApplicationContext();
        this.zzifk = string;
    }

    static int zzdm(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzdn(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.getInstance(context, null);
    }

    @KeepForSdk
    public static synchronized InstanceID getInstance(Context context, Bundle bundle) {
        String string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzifh == null) {
            zzifh = new zzo(context);
            zzifi = new zzl(context);
        }
        zzifm = Integer.toString(InstanceID.zzdm(context));
        InstanceID instanceID = zzifg.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string, bundle);
            zzifg.put(string, instanceID);
        }
        return instanceID;
    }

    static String zzo(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private final KeyPair zzave() {
        if (this.zzifj == null) {
            String string = this.zzifk;
            this.zzifj = zzifh.zzib(string);
        }
        if (this.zzifj == null) {
            this.zzifl = System.currentTimeMillis();
            this.zzifj = zzifh.zzc(this.zzifk, this.zzifl);
        }
        return this.zzifj;
    }

    @KeepForSdk
    public String getSubtype() {
        return this.zzifk;
    }

    public String getId() {
        return InstanceID.zza(this.zzave());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.zzifl == 0L && (string = zzifh.get(this.zzifk, "cre")) != null) {
            this.zzifl = Long.parseLong(string);
        }
        return this.zzifl;
    }

    public void deleteInstanceID() throws IOException {
        this.zza("*", "*", null);
        this.zzavf();
    }

    public final void zzavf() {
        this.zzifl = 0L;
        String string = this.zzifk;
        zzifh.zzhz(String.valueOf(string).concat("|"));
        this.zzifj = null;
    }

    public void deleteToken(String string, String string2) throws IOException {
        this.zza(string, string2, null);
    }

    public final void zza(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzifh.zzf(this.zzifk, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzifk) ? string : this.zzifk);
        bundle.putString("X-subtype", "".equals(this.zzifk) ? string : this.zzifk);
        zzl.zzj(zzifi.zza(bundle, this.zzave()));
    }

    public static zzo zzavg() {
        return zzifh;
    }

    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        boolean bl;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl2 = true;
        String string4 = zzifh.get("appVersion");
        if (string4 == null || !string4.equals(zzifm)) {
            bl = true;
        } else {
            String string5 = zzifh.get("lastToken");
            if (string5 == null) {
                bl = true;
            } else {
                Long l = Long.parseLong(string5);
                bl = System.currentTimeMillis() / 1000L - l > 604800L;
            }
        }
        if ((string3 = bl ? null : zzifh.zze(this.zzifk, string, string2)) != null) {
            return string3;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle.getString("ttl") != null) {
            bl2 = false;
        }
        if ("jwt".equals(bundle.getString("type"))) {
            bl2 = false;
        }
        if ((string3 = this.zzb(string, string2, bundle)) != null && bl2) {
            zzifh.zza(this.zzifk, string, string2, string3, zzifm);
        }
        return string3;
    }

    public final String zzb(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string4 = string3 = "".equals(this.zzifk) ? string : this.zzifk;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string3);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string3);
        }
        return zzl.zzj(zzifi.zza(bundle, this.zzave()));
    }
}

