/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zza;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

@Hide
public final class zzaf {
    private SharedPreferences zza;
    private Context zzb;

    public zzaf(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    private zzaf(Context context, String string) {
        block4: {
            this.zzb = context;
            this.zza = context.getSharedPreferences(string, 0);
            String string2 = String.valueOf(string);
            String string3 = String.valueOf("-no-backup");
            String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            zzaf zzaf2 = this;
            File file = zzx.zza((Context)zzaf2.zzb);
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzaf2.zza()) {
                        Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                        InstanceIDListenerService.zza(zzaf2.zzb, zzaf2);
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                    String string5 = String.valueOf(iOException.getMessage());
                    Log.d((String)"InstanceID/Store", (String)(string5.length() != 0 ? "Error creating file in no backup dir: ".concat(string5) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    @Hide
    public final boolean zza() {
        return this.zza.getAll().isEmpty();
    }

    private static String zzc(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    final synchronized String zza(String string, String string2) {
        return this.zza.getString(new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString(), null);
    }

    final synchronized String zza(String string) {
        return this.zza.getString(string, null);
    }

    private final synchronized void zza(SharedPreferences.Editor editor, String string, String string2, String string3) {
        editor.putString(new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString(), string3);
    }

    public final synchronized void zzb(String string) {
        SharedPreferences.Editor editor = this.zza.edit();
        for (String string2 : this.zza.getAll().keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public final synchronized void zzb() {
        this.zza.edit().clear().commit();
    }

    public final synchronized String zza(String string, String string2, String string3) {
        String string4 = zzaf.zzc(string, string2, string3);
        return this.zza.getString(string4, null);
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzaf.zzc(string, string2, string3);
        SharedPreferences.Editor editor = this.zza.edit();
        editor.putString(string6, string4);
        editor.putString("appVersion", string5);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public final synchronized void zzb(String string, String string2, String string3) {
        String string4 = zzaf.zzc(string, string2, string3);
        SharedPreferences.Editor editor = this.zza.edit();
        editor.remove(string4);
        editor.commit();
    }

    final synchronized KeyPair zza(String string, long l) {
        KeyPair keyPair = com.google.android.gms.iid.zza.zza();
        SharedPreferences.Editor editor = this.zza.edit();
        this.zza(editor, string, "|P|", InstanceID.zza(keyPair.getPublic().getEncoded()));
        this.zza(editor, string, "|K|", InstanceID.zza(keyPair.getPrivate().getEncoded()));
        this.zza(editor, string, "cre", Long.toString(l));
        editor.commit();
        return keyPair;
    }

    final KeyPair zzc(String string) {
        String string2 = this.zza(string, "|P|");
        String string3 = this.zza(string, "|K|");
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID/Store", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            InstanceIDListenerService.zza(this.zzb, this);
            return null;
        }
    }
}

