/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zzaf;
import com.google.android.gms.iid.zzak;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Deprecated
public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    private static Map<String, InstanceID> zzbq = new ArrayMap();
    private static long zzbr = TimeUnit.DAYS.toSeconds(7L);
    private static zzak zzbs;
    private static zzaf zzbt;
    private static String zzbu;
    private Context zzk;
    private String zzbv = "";

    private InstanceID(Context context, String string) {
        this.zzk = context.getApplicationContext();
        this.zzbv = string;
    }

    static int zzg(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzh(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    @Deprecated
    public static InstanceID getInstance(Context context) {
        return InstanceID.getInstance(context, null);
    }

    @KeepForSdk
    public static synchronized InstanceID getInstance(Context context, Bundle bundle) {
        Object object;
        String string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzbs == null) {
            object = context.getPackageName();
            Log.w((String)"InstanceID", (String)new StringBuilder(73 + String.valueOf(object).length()).append("Instance ID SDK is deprecated, ").append((String)object).append(" should update to use Firebase Instance ID").toString());
            zzbs = new zzak(context);
            zzbt = new zzaf(context);
        }
        zzbu = Integer.toString(InstanceID.zzg(context));
        object = zzbq.get(string);
        if (object == null) {
            object = new InstanceID(context, string);
            zzbq.put(string, (InstanceID)object);
        }
        return object;
    }

    private final KeyPair getKeyPair() {
        return zzbs.zzj(this.zzbv).getKeyPair();
    }

    @KeepForSdk
    public String getSubtype() {
        return this.zzbv;
    }

    @Deprecated
    public String getId() {
        return InstanceID.zzd(this.getKeyPair());
    }

    static String zzd(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    @Deprecated
    public long getCreationTime() {
        return zzbs.zzj(this.zzbv).getCreationTime();
    }

    @Deprecated
    public void deleteInstanceID() throws IOException {
        this.zzd("*", "*", null);
        this.zzm();
    }

    final void zzm() {
        zzbs.zzk(this.zzbv);
    }

    @Deprecated
    public void deleteToken(String string, String string2) throws IOException {
        this.zzd(string, string2, null);
    }

    public final void zzd(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzbs.zzf(this.zzbv, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzbv) ? string : this.zzbv);
        bundle.putString("X-subtype", "".equals(this.zzbv) ? string : this.zzbv);
        zzaf.zzi(zzbt.zzd(bundle, this.getKeyPair()));
    }

    public static zzak zzn() {
        return zzbs;
    }

    @Deprecated
    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    @Deprecated
    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        boolean bl;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        String string3 = null;
        String string4 = zzbs.get("appVersion");
        if (string4 == null || !string4.equals(zzbu)) {
            bl = true;
        } else {
            String string5 = zzbs.get("lastToken");
            if (string5 == null) {
                bl = true;
            } else {
                Long l = Long.parseLong(string5);
                bl = System.currentTimeMillis() / 1000L - l > zzbr;
            }
        }
        if (!bl) {
            string3 = zzbs.zze(this.zzbv, string, string2);
        }
        if (string3 == null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            if ((string3 = this.zze(string, string2, bundle)) != null) {
                zzbs.zzd(this.zzbv, string, string2, string3, zzbu);
            }
        }
        return string3;
    }

    public final String zze(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        String string4;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string5 = string4 = "".equals(this.zzbv) ? string : this.zzbv;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string4);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string4);
        }
        if ("RST".equals(string3 = zzaf.zzi(zzbt.zzd(bundle, this.getKeyPair()))) || string3.startsWith("RST|")) {
            InstanceIDListenerService.zzd(this.zzk, zzbs);
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        return string3;
    }
}

