/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.iid.zzl;
import com.google.android.gms.iid.zzm;
import com.google.android.gms.iid.zzq;

public class MessengerCompat
implements ReflectedParcelable {
    private Messenger zzab;
    private zzl zzby;
    public static final Parcelable.Creator<MessengerCompat> CREATOR = new zzq();

    public MessengerCompat(IBinder iBinder) {
        IInterface iInterface;
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzab = new Messenger(iBinder);
            return;
        }
        IBinder iBinder2 = iBinder;
        this.zzby = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.iid.IMessengerCompat")) instanceof zzl ? (zzl)iInterface : new zzm(iBinder2));
    }

    public final void send(Message message) throws RemoteException {
        if (this.zzab != null) {
            this.zzab.send(message);
            return;
        }
        this.zzby.send(message);
    }

    private final IBinder getBinder() {
        if (this.zzab != null) {
            return this.zzab.getBinder();
        }
        return this.zzby.asBinder();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((MessengerCompat)object).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzab != null) {
            parcel.writeStrongBinder(this.zzab.getBinder());
            return;
        }
        parcel.writeStrongBinder(this.zzby.asBinder());
    }
}

