/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.GuardedBy;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zzn;
import com.google.android.gms.iid.zzo;
import com.google.android.gms.iid.zzp;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class zzak {
    private SharedPreferences zzcz;
    private Context zzk;
    private final zzn zzda;
    @GuardedBy(value="this")
    private final Map<String, zzo> zzdb;

    public zzak(Context context) {
        this(context, new zzn());
    }

    @VisibleForTesting
    private zzak(Context context, zzn zzn2) {
        block4: {
            this.zzdb = new ArrayMap();
            this.zzk = context;
            this.zzcz = context.getSharedPreferences("com.google.android.gms.appid", 0);
            this.zzda = zzn2;
            String string = "com.google.android.gms.appid-no-backup";
            zzak zzak2 = this;
            File file = ContextCompat.getNoBackupFilesDir((Context)zzak2.zzk);
            File file2 = new File(file, string);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzak2.isEmpty()) {
                        Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                        InstanceIDListenerService.zzd(zzak2.zzk, zzak2);
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                    String string2 = String.valueOf(iOException.getMessage());
                    Log.d((String)"InstanceID/Store", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final boolean isEmpty() {
        return this.zzcz.getAll().isEmpty();
    }

    private static String zzd(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    @Nullable
    final synchronized String get(String string) {
        return this.zzcz.getString(string, null);
    }

    public final synchronized void zzi(String string) {
        SharedPreferences.Editor editor = this.zzcz.edit();
        for (String string2 : this.zzcz.getAll().keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public final synchronized void zzx() {
        this.zzdb.clear();
        zzn.zzi(this.zzk);
        this.zzcz.edit().clear().commit();
    }

    public final synchronized String zze(String string, String string2, String string3) {
        String string4 = zzak.zzd(string, string2, string3);
        return this.zzcz.getString(string4, null);
    }

    public final synchronized void zzd(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzak.zzd(string, string2, string3);
        SharedPreferences.Editor editor = this.zzcz.edit();
        editor.putString(string6, string4);
        editor.putString("appVersion", string5);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public final synchronized void zzf(String string, String string2, String string3) {
        String string4 = zzak.zzd(string, string2, string3);
        SharedPreferences.Editor editor = this.zzcz.edit();
        editor.remove(string4);
        editor.commit();
    }

    public final synchronized zzo zzj(String string) {
        zzo zzo2 = this.zzdb.get(string);
        if (zzo2 != null) {
            return zzo2;
        }
        try {
            zzo2 = this.zzda.zze(this.zzk, string);
        }
        catch (zzp zzp2) {
            Log.w((String)"InstanceID/Store", (String)"Stored data is corrupt, generating new identity");
            InstanceIDListenerService.zzd(this.zzk, this);
            zzo2 = this.zzda.zzf(this.zzk, string);
        }
        this.zzdb.put(string, zzo2);
        return zzo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzk(String string) {
        zzak zzak2 = this;
        synchronized (zzak2) {
            this.zzdb.remove(string);
        }
        zzn.zzg(this.zzk, string);
        this.zzi(String.valueOf(string).concat("|"));
    }

    static String zzh(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }
}

