/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerWrapper;
import com.google.android.gms.internal.zzaqs;

public class zzaqw
implements PackageManagerWrapper {
    private static zzaqw zzbil;
    private final Context zzqr;
    private final boolean zzbim;

    public static synchronized zzaqw zzh(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzbil == null || zzaqw.zzbil.zzqr != context2 || zzaqw.zzbil.zzbim != bl) {
            zzbil = new zzaqw(context2, bl);
        }
        return zzbil;
    }

    zzaqw(Context context, boolean bl) {
        this.zzqr = context;
        this.zzbim = bl;
    }

    @Override
    public String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzbim && (stringArray = this.zzqr.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzaqs.zzbn(this.zzqr);
        if (stringArray != null) {
            try {
                String string = stringArray.zzjJ(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzaqs zzaqs2;
        if (this.zzbim) {
            try {
                return this.zzqr.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzaqs2 = zzaqs.zzbn(this.zzqr)) != null) {
            try {
                PackageInfo packageInfo = zzaqs2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzaqs zzaqs2;
        if (this.zzbim) {
            try {
                return this.zzqr.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzaqs2 = zzaqs.zzbn(this.zzqr)) != null) {
            try {
                ApplicationInfo applicationInfo = zzaqs2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzbim && this.zzqr.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzqr.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzaqs zzaqs2 = zzaqs.zzbn(this.zzqr);
        if (zzaqs2 != null) {
            try {
                return zzaqs2.zzeQ(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public String getCallingPackage(Activity activity) {
        ComponentName componentName = this.getCallingActivity(activity);
        if (componentName != null) {
            return componentName.getPackageName();
        }
        return null;
    }

    @Override
    public ComponentName getCallingActivity(Activity activity) {
        zzaqs zzaqs2;
        ComponentName componentName = activity.getCallingActivity();
        if (componentName != null && componentName.getPackageName() != null && this.zzeS(componentName.getPackageName()) && (zzaqs2 = zzaqs.zzbn(this.zzqr)) != null) {
            try {
                ComponentName componentName2 = zzaqs2.zzeR(componentName.getClassName());
                if (componentName2 != null) {
                    return componentName2;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting calling activity", (Throwable)remoteException);
            }
        }
        return componentName;
    }

    private boolean zzeS(String string) {
        return string.equals("com.google.android.instantapps.supervisor");
    }

    @Override
    public boolean isInstantApp(int n) {
        zzaqs zzaqs2 = zzaqs.zzbn(this.zzqr);
        if (zzaqs2 != null) {
            try {
                return zzaqs2.zzjJ(n) != null;
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }
}

