/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerWrapper;
import com.google.android.gms.internal.zzade;
import com.google.android.gms.internal.zzarf;

public class zzarj
implements PackageManagerWrapper {
    private static zzarj zzbiS;
    private final Context zzqn;
    private final boolean zzbiT;

    public static synchronized zzarj zzh(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzbiS == null || zzarj.zzbiS.zzqn != context2 || zzarj.zzbiS.zzbiT != bl) {
            zzbiS = new zzarj(context2, bl);
        }
        return zzbiS;
    }

    zzarj(Context context, boolean bl) {
        this.zzqn = context;
        this.zzbiT = bl;
    }

    @Override
    public String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzbiT && (stringArray = this.zzqn.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzarf.zzbF(this.zzqn);
        if (stringArray != null) {
            try {
                String string = stringArray.zzjS(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzarf zzarf2;
        if (this.zzbiT) {
            try {
                return this.zzqn.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzarf2 = zzarf.zzbF(this.zzqn)) != null) {
            try {
                PackageInfo packageInfo = zzarf2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzarf zzarf2;
        if (this.zzbiT) {
            try {
                return this.zzqn.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzarf2 = zzarf.zzbF(this.zzqn)) != null) {
            try {
                ApplicationInfo applicationInfo = zzarf2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzbiT && this.zzqn.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzqn.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzarf zzarf2 = zzarf.zzbF(this.zzqn);
        if (zzarf2 != null) {
            try {
                return zzarf2.zzeM(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public String getCallingPackage(Activity activity) {
        ComponentName componentName = this.getCallingActivity(activity);
        if (componentName != null) {
            return componentName.getPackageName();
        }
        return null;
    }

    @Override
    public ComponentName getCallingActivity(Activity activity) {
        zzarf zzarf2;
        ComponentName componentName = activity.getCallingActivity();
        if (componentName != null && componentName.getPackageName() != null && this.zzeO(componentName.getPackageName()) && (zzarf2 = zzarf.zzbF(this.zzqn)) != null) {
            try {
                ComponentName componentName2 = zzarf2.zzeN(componentName.getClassName());
                if (componentName2 != null) {
                    return componentName2;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting calling activity", (Throwable)remoteException);
            }
        }
        return componentName;
    }

    private boolean zzeO(String string) {
        return string.equals("com.google.android.instantapps.supervisor");
    }

    @Override
    public boolean isInstantApp(int n) {
        if (Process.myUid() == n) {
            return zzade.zzbg((Context)this.zzqn);
        }
        zzarf zzarf2 = zzarf.zzbF(this.zzqn);
        if (zzarf2 != null) {
            try {
                return zzarf2.zzjS(n) != null;
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }
}

