/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.zzarg;
import com.google.android.gms.internal.zzarp;

public class zzarf {
    private static zzarf zzbiK;
    private final Context mContext;

    @Nullable
    public static synchronized zzarf zzbF(Context context) {
        if (zzbiK == null) {
            zzbiK = zzarf.zzbG(context.getApplicationContext());
        }
        return zzbiK;
    }

    private static zzarf zzbG(Context context) {
        if (!zzarf.zzHH()) {
            return null;
        }
        if (!zzarp.zzbH(context)) {
            return null;
        }
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(zzarg.zzbiL.getAuthority(), 0);
        if (providerInfo == null) {
            return null;
        }
        if (!providerInfo.packageName.equals("com.google.android.gms")) {
            String string = String.valueOf(providerInfo.packageName);
            Log.e((String)"IAMetadataClient", (String)new StringBuilder(85 + String.valueOf(string).length()).append("Package ").append(string).append(" is invalid for instant apps content provider; instant apps will be disabled.").toString());
            return null;
        }
        return new zzarf(context);
    }

    private static boolean zzHH() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private zzarf(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    private Bundle zzh(String string, Bundle bundle) throws RemoteException {
        Bundle bundle2;
        long l = Binder.clearCallingIdentity();
        try {
            bundle2 = this.mContext.getContentResolver().call(zzarg.zzbiL, string, null, bundle);
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
        }
        if (bundle2 == null) {
            throw new RemoteException();
        }
        return bundle2;
    }

    public String zzjS(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zzh("getAppPackageForUid", bundle).getString("result");
    }

    public ApplicationInfo getApplicationInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (ApplicationInfo)this.zzh("getWHApplicationInfo", bundle).getParcelable("result");
    }

    public PackageInfo getPackageInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (PackageInfo)this.zzh("getWHPackageInfo", bundle).getParcelable("result");
    }

    public String zzeM(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzh("getApplicationLabel", bundle).getString("result");
    }

    public ComponentName zzeN(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("shadowActivity", string);
        return (ComponentName)this.zzh("getCallingActivity", bundle).getParcelable("result");
    }
}

