/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.zzcdc;
import com.google.android.gms.internal.zzcde;

public final class zzcdb {
    private static zzcdb zzbhu;
    private final Context mContext;

    @Nullable
    public static synchronized zzcdb zzbf(Context context) {
        if (zzbhu == null) {
            zzcdb zzcdb2;
            Context context2 = context.getApplicationContext();
            if (!(Build.VERSION.SDK_INT >= 16)) {
                zzcdb2 = null;
            } else if (!zzcde.zzbg(context2)) {
                zzcdb2 = null;
            } else {
                ProviderInfo providerInfo = context2.getPackageManager().resolveContentProvider(zzcdc.zzbhv.getAuthority(), 0);
                if (providerInfo == null) {
                    zzcdb2 = null;
                } else if (!providerInfo.packageName.equals("com.google.android.gms")) {
                    String string = String.valueOf(providerInfo.packageName);
                    Log.e((String)"IAMetadataClient", (String)new StringBuilder(85 + String.valueOf(string).length()).append("Package ").append(string).append(" is invalid for instant apps content provider; instant apps will be disabled.").toString());
                    zzcdb2 = null;
                } else {
                    zzcdb2 = new zzcdb(context2);
                }
            }
            zzbhu = zzcdb2;
        }
        return zzbhu;
    }

    private zzcdb(Context context) {
        this.mContext = context;
    }

    @TargetApi(value=16)
    private final Bundle zzg(String string, Bundle bundle) throws RemoteException {
        Bundle bundle2;
        long l = Binder.clearCallingIdentity();
        try {
            bundle2 = this.mContext.getContentResolver().call(zzcdc.zzbhv, string, null, bundle);
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
        }
        if (bundle2 == null) {
            throw new RemoteException();
        }
        return bundle2;
    }

    public final String zzbh(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zzg("getAppPackageForUid", bundle).getString("result");
    }

    public final ApplicationInfo getApplicationInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (ApplicationInfo)this.zzg("getWHApplicationInfo", bundle).getParcelable("result");
    }

    public final PackageInfo getPackageInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (PackageInfo)this.zzg("getWHPackageInfo", bundle).getParcelable("result");
    }

    public final String zzdu(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("getApplicationLabel", bundle).getString("result");
    }

    public final ComponentName zzdv(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("shadowActivity", string);
        return (ComponentName)this.zzg("getCallingActivity", bundle).getParcelable("result");
    }

    public final boolean isInstantApp(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("isInstantApp", bundle).getBoolean("result");
    }
}

