/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerWrapper;
import com.google.android.gms.internal.zzbgy;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbp;

public final class zzcbr
implements PackageManagerWrapper {
    private static zzcbr zzbhs;
    private final Context zzqD;
    private final boolean zzbht;

    public static synchronized zzcbr zzi(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzbhs == null || zzcbr.zzbhs.zzqD != context2 || zzcbr.zzbhs.zzbht != bl) {
            zzbhs = new zzcbr(context2, bl);
        }
        return zzbhs;
    }

    private zzcbr(Context context, boolean bl) {
        this.zzqD = context;
        this.zzbht = bl;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzbht && (stringArray = this.zzqD.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzcbp.zzbf(this.zzqD);
        if (stringArray != null) {
            try {
                String string = stringArray.zzbi(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcbp zzcbp2;
        if (this.zzbht) {
            try {
                return this.zzqD.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcbp2 = zzcbp.zzbf(this.zzqD)) != null) {
            try {
                PackageInfo packageInfo = zzcbp2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcbp zzcbp2;
        if (this.zzbht) {
            try {
                return this.zzqD.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcbp2 = zzcbp.zzbf(this.zzqD)) != null) {
            try {
                ApplicationInfo applicationInfo = zzcbp2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzbht && this.zzqD.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzqD.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzcbp zzcbp2 = zzcbp.zzbf(this.zzqD);
        if (zzcbp2 != null) {
            try {
                return zzcbp2.zzdt(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getCallingPackage(Activity activity) {
        return new zzcbk(activity).getCallingPackage();
    }

    @Override
    public final ComponentName getCallingActivity(Activity activity) {
        return new zzcbk(activity).getCallingActivity();
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzqD.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzcbp zzcbp2 = zzcbp.zzbf(this.zzqD);
        if (zzcbp2 != null) {
            try {
                return zzcbp2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final boolean isInstantApp(int n) {
        if (Process.myUid() == n) {
            return zzbgy.zzaN((Context)this.zzqD);
        }
        zzcbp zzcbp2 = zzcbp.zzbf(this.zzqD);
        if (zzcbp2 != null) {
            try {
                return zzcbp2.zzbi(n) != null;
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }
}

