/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerCompat;
import com.google.android.gms.internal.zzbxo;

public final class zzbxs
implements PackageManagerCompat {
    private static zzbxs zzhvx;
    private final Context zzahz;
    private final boolean zzhvy;

    public static synchronized zzbxs zzi(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzhvx == null || zzbxs.zzhvx.zzahz != context2 || !zzbxs.zzhvx.zzhvy) {
            zzhvx = new zzbxs(context2, true);
        }
        return zzhvx;
    }

    private zzbxs(Context context, boolean bl) {
        this.zzahz = context;
        this.zzhvy = true;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzhvy && (stringArray = this.zzahz.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzbxo.zzdh(this.zzahz);
        if (stringArray != null) {
            try {
                String string = stringArray.zzdn(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzbxo zzbxo2;
        if (this.zzhvy) {
            try {
                return this.zzahz.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzbxo2 = zzbxo.zzdh(this.zzahz)) != null) {
            try {
                PackageInfo packageInfo = zzbxo2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzbxo zzbxo2;
        if (this.zzhvy) {
            try {
                return this.zzahz.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzbxo2 = zzbxo.zzdh(this.zzahz)) != null) {
            try {
                ApplicationInfo applicationInfo = zzbxo2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzhvy && this.zzahz.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzahz.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzbxo zzbxo2 = zzbxo.zzdh(this.zzahz);
        if (zzbxo2 != null) {
            try {
                return zzbxo2.zzhx(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getInstallerPackageName(String string) {
        zzbxo zzbxo2;
        IllegalArgumentException illegalArgumentException = null;
        if (this.zzhvy) {
            try {
                return this.zzahz.getPackageManager().getInstallerPackageName(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        if ((zzbxo2 = zzbxo.zzdh(this.zzahz)) != null) {
            try {
                if (zzbxo2.zzhw(string) != 0) {
                    return "com.android.vending";
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting UID for app package", (Throwable)remoteException);
            }
        }
        throw illegalArgumentException == null ? new IllegalArgumentException() : illegalArgumentException;
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzahz.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzbxo zzbxo2 = zzbxo.zzdh(this.zzahz);
        if (zzbxo2 != null) {
            try {
                return zzbxo2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final int getInstantAppCookieMaxSize() {
        zzbxo zzbxo2 = zzbxo.zzdh(this.zzahz);
        if (zzbxo2 != null) {
            try {
                return zzbxo2.getInstantAppCookieMaxSize();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error fetching max cookie size", (Throwable)remoteException);
            }
        }
        return 0;
    }

    @Override
    public final boolean setInstantAppCookie(byte[] byArray) {
        zzbxo zzbxo2 = zzbxo.zzdh(this.zzahz);
        if (zzbxo2 != null) {
            try {
                return zzbxo2.zza(Process.myUid(), byArray);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final byte[] getInstantAppCookie() {
        zzbxo zzbxo2 = zzbxo.zzdh(this.zzahz);
        if (zzbxo2 != null) {
            try {
                return zzbxo2.zzdo(Process.myUid());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return null;
    }
}

