/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerCompat;
import com.google.android.gms.internal.zzcby;

public final class zzccc
implements PackageManagerCompat {
    private static zzccc zzieu;
    private final Context zzaif;
    private final boolean zziev;

    public static synchronized zzccc zzj(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzieu == null || zzccc.zzieu.zzaif != context2 || !zzccc.zzieu.zziev) {
            zzieu = new zzccc(context2, true);
        }
        return zzieu;
    }

    private zzccc(Context context, boolean bl) {
        this.zzaif = context;
        this.zziev = true;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zziev && (stringArray = this.zzaif.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzcby.zzdo(this.zzaif);
        if (stringArray != null) {
            try {
                String string = stringArray.zzdt(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcby zzcby2;
        if (this.zziev) {
            try {
                return this.zzaif.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcby2 = zzcby.zzdo(this.zzaif)) != null) {
            try {
                PackageInfo packageInfo = zzcby2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcby zzcby2;
        if (this.zziev) {
            try {
                return this.zzaif.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcby2 = zzcby.zzdo(this.zzaif)) != null) {
            try {
                ApplicationInfo applicationInfo = zzcby2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zziev && this.zzaif.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzaif.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzcby zzcby2 = zzcby.zzdo(this.zzaif);
        if (zzcby2 != null) {
            try {
                return zzcby2.zzhx(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getInstallerPackageName(String string) {
        zzcby zzcby2;
        IllegalArgumentException illegalArgumentException = null;
        if (this.zziev) {
            try {
                return this.zzaif.getPackageManager().getInstallerPackageName(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        if ((zzcby2 = zzcby.zzdo(this.zzaif)) != null) {
            try {
                if (zzcby2.zzhw(string) != 0) {
                    return "com.android.vending";
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting UID for app package", (Throwable)remoteException);
            }
        }
        throw illegalArgumentException == null ? new IllegalArgumentException() : illegalArgumentException;
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzaif.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzcby zzcby2 = zzcby.zzdo(this.zzaif);
        if (zzcby2 != null) {
            try {
                return zzcby2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final int getInstantAppCookieMaxSize() {
        zzcby zzcby2 = zzcby.zzdo(this.zzaif);
        if (zzcby2 != null) {
            try {
                return zzcby2.getInstantAppCookieMaxSize();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error fetching max cookie size", (Throwable)remoteException);
            }
        }
        return 0;
    }

    @Override
    public final boolean setInstantAppCookie(byte[] byArray) {
        zzcby zzcby2 = zzcby.zzdo(this.zzaif);
        if (zzcby2 != null) {
            try {
                return zzcby2.zza(Process.myUid(), byArray);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final byte[] getInstantAppCookie() {
        zzcby zzcby2 = zzcby.zzdo(this.zzaif);
        if (zzcby2 != null) {
            try {
                return zzcby2.zzdu(Process.myUid());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return null;
    }
}

