/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerCompat;
import com.google.android.gms.internal.zzcdb;

public final class zzcdf
implements PackageManagerCompat {
    private static zzcdf zzihp;
    private final Context zzair;
    private final boolean zzihq;

    public static synchronized zzcdf zzj(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzihp == null || zzcdf.zzihp.zzair != context2 || !zzcdf.zzihp.zzihq) {
            zzihp = new zzcdf(context2, true);
        }
        return zzihp;
    }

    private zzcdf(Context context, boolean bl) {
        this.zzair = context;
        this.zzihq = true;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzihq && (stringArray = this.zzair.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzcdb.zzdr(this.zzair);
        if (stringArray != null) {
            try {
                String string = stringArray.zzdt(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcdb zzcdb2;
        if (this.zzihq) {
            try {
                return this.zzair.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcdb2 = zzcdb.zzdr(this.zzair)) != null) {
            try {
                PackageInfo packageInfo = zzcdb2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcdb zzcdb2;
        if (this.zzihq) {
            try {
                return this.zzair.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcdb2 = zzcdb.zzdr(this.zzair)) != null) {
            try {
                ApplicationInfo applicationInfo = zzcdb2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzihq && this.zzair.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzair.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzcdb zzcdb2 = zzcdb.zzdr(this.zzair);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.zzid(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getInstallerPackageName(String string) {
        zzcdb zzcdb2;
        IllegalArgumentException illegalArgumentException = null;
        if (this.zzihq) {
            try {
                return this.zzair.getPackageManager().getInstallerPackageName(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        if ((zzcdb2 = zzcdb.zzdr(this.zzair)) != null) {
            try {
                if (zzcdb2.zzic(string) != 0) {
                    return "com.android.vending";
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting UID for app package", (Throwable)remoteException);
            }
        }
        throw illegalArgumentException == null ? new IllegalArgumentException() : illegalArgumentException;
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzair.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzcdb zzcdb2 = zzcdb.zzdr(this.zzair);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final int getInstantAppCookieMaxSize() {
        zzcdb zzcdb2 = zzcdb.zzdr(this.zzair);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.getInstantAppCookieMaxSize();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error fetching max cookie size", (Throwable)remoteException);
            }
        }
        return 0;
    }

    @Override
    public final boolean setInstantAppCookie(byte[] byArray) {
        zzcdb zzcdb2 = zzcdb.zzdr(this.zzair);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.zza(Process.myUid(), byArray);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final byte[] getInstantAppCookie() {
        zzcdb zzcdb2 = zzcdb.zzdr(this.zzair);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.zzdu(Process.myUid());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return null;
    }
}

