/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerCompat;
import com.google.android.gms.internal.zzcev;

public final class zzcfa
implements PackageManagerCompat {
    private static zzcfa zza;
    private final Context zzb;
    private final boolean zzc;

    public static synchronized zzcfa zza(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zza == null || zzcfa.zza.zzb != context2 || !zzcfa.zza.zzc) {
            zza = new zzcfa(context2, true);
        }
        return zza;
    }

    private zzcfa(Context context, boolean bl) {
        this.zzb = context;
        this.zzc = true;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzc && (stringArray = this.zzb.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzcev.zza(this.zzb);
        if (stringArray != null) {
            try {
                String string = stringArray.zza(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcev zzcev2;
        if (this.zzc) {
            try {
                return this.zzb.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcev2 = zzcev.zza(this.zzb)) != null) {
            try {
                PackageInfo packageInfo = zzcev2.zzb(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcev zzcev2;
        if (this.zzc) {
            try {
                return this.zzb.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcev2 = zzcev.zza(this.zzb)) != null) {
            try {
                ApplicationInfo applicationInfo = zzcev2.zza(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzc && this.zzb.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzb.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzcev zzcev2 = zzcev.zza(this.zzb);
        if (zzcev2 != null) {
            try {
                return zzcev2.zzb(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getInstallerPackageName(String string) {
        zzcev zzcev2;
        IllegalArgumentException illegalArgumentException = null;
        if (this.zzc) {
            try {
                return this.zzb.getPackageManager().getInstallerPackageName(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        if ((zzcev2 = zzcev.zza(this.zzb)) != null) {
            try {
                if (zzcev2.zza(string) != 0) {
                    return "com.android.vending";
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting UID for app package", (Throwable)remoteException);
            }
        }
        throw illegalArgumentException == null ? new IllegalArgumentException() : illegalArgumentException;
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzb.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzcev zzcev2 = zzcev.zza(this.zzb);
        if (zzcev2 != null) {
            try {
                return zzcev2.zzd(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final int getInstantAppCookieMaxSize() {
        zzcev zzcev2 = zzcev.zza(this.zzb);
        if (zzcev2 != null) {
            try {
                return zzcev2.zza();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error fetching max cookie size", (Throwable)remoteException);
            }
        }
        return 0;
    }

    @Override
    public final boolean setInstantAppCookie(byte[] byArray) {
        zzcev zzcev2 = zzcev.zza(this.zzb);
        if (zzcev2 != null) {
            try {
                return zzcev2.zza(Process.myUid(), byArray);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final byte[] getInstantAppCookie() {
        zzcev zzcev2 = zzcev.zza(this.zzb);
        if (zzcev2 != null) {
            try {
                return zzcev2.zzb(Process.myUid());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return null;
    }
}

