/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzarp;
import com.google.android.gms.internal.zzarq;
import com.google.android.gms.internal.zzarr;
import com.google.android.gms.internal.zzars;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzarv;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.zzv;

public class zzaru
extends zzari {
    private final zzart zzbkm;

    public zzaru(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzg.zzaA((Context)context));
    }

    public zzaru(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zzg zzg2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzg2);
        this.zzbkm = new zzart(context, this.zzbjV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzart zzart2 = this.zzbkm;
        synchronized (zzart2) {
            if (this.isConnected()) {
                try {
                    this.zzbkm.removeAllListeners();
                    this.zzbkm.zzHC();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzwV();
        zzac.zzw((Object)pendingIntent);
        zzac.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzarr)this.zzwW()).zza(l, true, pendingIntent);
    }

    public void zzc(PendingIntent pendingIntent) throws RemoteException {
        this.zzwV();
        zzac.zzw((Object)pendingIntent);
        ((zzarr)this.zzwW()).zzc(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzzv.zzb<Status> zzb2) throws RemoteException {
        this.zzwV();
        zzac.zzb((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        zzac.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzarr)this.zzwW()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(zzv zzv2, zzzv.zzb<Status> zzb2) throws RemoteException {
        this.zzwV();
        zzac.zzb((Object)((Object)zzv2), (Object)"removeGeofencingRequest can't be null.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzarr)this.zzwW()).zza(zzv2, zzb3);
    }

    public Location getLastLocation() {
        return this.zzbkm.getLastLocation();
    }

    public LocationAvailability zzHB() {
        return this.zzbkm.zzHB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzarv zzarv2, zzaaz<LocationCallback> zzaaz2, zzarp zzarp2) throws RemoteException {
        zzart zzart2 = this.zzbkm;
        synchronized (zzart2) {
            this.zzbkm.zza(zzarv2, zzaaz2, zzarp2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, zzaaz<LocationListener> zzaaz2, zzarp zzarp2) throws RemoteException {
        zzart zzart2 = this.zzbkm;
        synchronized (zzart2) {
            this.zzbkm.zza(locationRequest, zzaaz2, zzarp2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzarp zzarp2) throws RemoteException {
        this.zzbkm.zza(locationRequest, pendingIntent, zzarp2);
    }

    public void zza(zzaaz.zzb<LocationListener> zzb2, zzarp zzarp2) throws RemoteException {
        this.zzbkm.zza(zzb2, zzarp2);
    }

    public void zza(PendingIntent pendingIntent, zzarp zzarp2) throws RemoteException {
        this.zzbkm.zza(pendingIntent, zzarp2);
    }

    public void zzb(zzaaz.zzb<LocationCallback> zzb2, zzarp zzarp2) throws RemoteException {
        this.zzbkm.zzb(zzb2, zzarp2);
    }

    public void zzaC(boolean bl) throws RemoteException {
        this.zzbkm.zzaC(bl);
    }

    public void zzd(Location location) throws RemoteException {
        this.zzbkm.zzd(location);
    }

    public void zza(zzarp zzarp2) throws RemoteException {
        this.zzbkm.zza(zzarp2);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zzzv.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzwV();
        zzac.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzac.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzarr)this.zzwW()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzars.zza {
        private zzzv.zzb<LocationSettingsResult> zzbkn;

        public zzc(zzzv.zzb<LocationSettingsResult> zzb2) {
            zzac.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzbkn = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzbkn.setResult((Object)locationSettingsResult);
            this.zzbkn = null;
        }
    }

    private static final class zzb
    extends zzarq.zza {
        private zzzv.zzb<Status> zzbkn;

        public zzb(zzzv.zzb<Status> zzb2) {
            this.zzbkn = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzkp(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzkp(n);
        }

        private void zzkp(int n) {
            if (this.zzbkn == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzkl(LocationStatusCodes.zzkk(n));
            this.zzbkn.setResult((Object)status);
            this.zzbkn = null;
        }
    }

    private static final class zza
    extends zzarq.zza {
        private zzzv.zzb<Status> zzbkn;

        public zza(zzzv.zzb<Status> zzb2) {
            this.zzbkn = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzbkn == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzkl(LocationStatusCodes.zzkk(n));
            this.zzbkn.setResult((Object)status);
            this.zzbkn = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

