/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzasm;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzOV = null;
        private int zzbjH = 0;
        private long zzbjI = Long.MIN_VALUE;
        private short zzbjJ = (short)-1;
        private double zzbjK;
        private double zzbjL;
        private float zzbjM;
        private int zzbjN = 0;
        private int zzbjO = -1;

        public Builder setRequestId(String string) {
            this.zzOV = string;
            return this;
        }

        public Builder setTransitionTypes(int n) {
            this.zzbjH = n;
            return this;
        }

        public Builder setExpirationDuration(long l) {
            this.zzbjI = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public Builder setCircularRegion(double d, double d2, float f) {
            this.zzbjJ = 1;
            this.zzbjK = d;
            this.zzbjL = d2;
            this.zzbjM = f;
            return this;
        }

        public Builder setNotificationResponsiveness(int n) {
            this.zzbjN = n;
            return this;
        }

        public Builder setLoiteringDelay(int n) {
            this.zzbjO = n;
            return this;
        }

        public Geofence build() {
            if (this.zzOV == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzbjH == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzbjH & 4) != 0 && this.zzbjO < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzbjI == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzbjJ == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzbjN < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzasm(this.zzOV, this.zzbjH, 1, this.zzbjK, this.zzbjL, this.zzbjM, this.zzbjI, this.zzbjN, this.zzbjO);
        }
    }
}

