/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzasm;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzi;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zza {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzi();
    private final List<zzasm> zzbjS;
    private final int zzbjT;
    private final String mTag;

    GeofencingRequest(List<zzasm> list, int n, String string) {
        this.zzbjS = list;
        this.zzbjT = n;
        this.mTag = string;
    }

    public List<zzasm> zzIe() {
        return this.zzbjS;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzbjS);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzbjT;
    }

    public String getTag() {
        return this.mTag;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static final class Builder {
        private final List<zzasm> zzbjS = new ArrayList<zzasm>();
        private int zzbjT = 5;
        private String mTag = "";

        public Builder addGeofence(Geofence geofence) {
            zzac.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzac.zzb((boolean)(geofence instanceof zzasm), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzbjS.add((zzasm)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int n) {
            this.zzbjT = Builder.zzkh(n);
            return this;
        }

        public static int zzkh(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzac.zzb((!this.zzbjS.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzbjS, this.zzbjT, this.mTag);
        }
    }
}

