/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzarv;
import com.google.android.gms.internal.zzasc;
import com.google.android.gms.internal.zzasd;
import com.google.android.gms.internal.zzase;
import com.google.android.gms.internal.zzasf;
import com.google.android.gms.internal.zzasg;
import com.google.android.gms.internal.zzasi;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.zzt;

public class zzash
extends zzarv {
    private final zzasg zzbkK;

    public zzash(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzg.zzaS((Context)context));
    }

    public zzash(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zzg zzg2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzg2);
        this.zzbkK = new zzasg(context, this.zzbkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzasg zzasg2 = this.zzbkK;
        synchronized (zzasg2) {
            if (this.isConnected()) {
                try {
                    this.zzbkK.removeAllListeners();
                    this.zzbkK.zzIq();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzxC();
        zzac.zzw((Object)pendingIntent);
        zzac.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzase)this.zzxD()).zza(l, true, pendingIntent);
    }

    public void zzc(PendingIntent pendingIntent) throws RemoteException {
        this.zzxC();
        zzac.zzw((Object)pendingIntent);
        ((zzase)this.zzxD()).zzc(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzaad.zzb<Status> zzb2) throws RemoteException {
        this.zzxC();
        zzac.zzb((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        zzac.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzase)this.zzxD()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(zzt zzt2, zzaad.zzb<Status> zzb2) throws RemoteException {
        this.zzxC();
        zzac.zzb((Object)((Object)zzt2), (Object)"removeGeofencingRequest can't be null.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzase)this.zzxD()).zza(zzt2, zzb3);
    }

    public Location getLastLocation() {
        return this.zzbkK.getLastLocation();
    }

    public LocationAvailability zzIp() {
        return this.zzbkK.zzIp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzasi zzasi2, zzabh<LocationCallback> zzabh2, zzasc zzasc2) throws RemoteException {
        zzasg zzasg2 = this.zzbkK;
        synchronized (zzasg2) {
            this.zzbkK.zza(zzasi2, zzabh2, zzasc2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, zzabh<LocationListener> zzabh2, zzasc zzasc2) throws RemoteException {
        zzasg zzasg2 = this.zzbkK;
        synchronized (zzasg2) {
            this.zzbkK.zza(locationRequest, zzabh2, zzasc2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzasc zzasc2) throws RemoteException {
        this.zzbkK.zza(locationRequest, pendingIntent, zzasc2);
    }

    public void zza(zzabh.zzb<LocationListener> zzb2, zzasc zzasc2) throws RemoteException {
        this.zzbkK.zza(zzb2, zzasc2);
    }

    public void zza(PendingIntent pendingIntent, zzasc zzasc2) throws RemoteException {
        this.zzbkK.zza(pendingIntent, zzasc2);
    }

    public void zzb(zzabh.zzb<LocationCallback> zzb2, zzasc zzasc2) throws RemoteException {
        this.zzbkK.zzb(zzb2, zzasc2);
    }

    public void zzaH(boolean bl) throws RemoteException {
        this.zzbkK.zzaH(bl);
    }

    public void zzd(Location location) throws RemoteException {
        this.zzbkK.zzd(location);
    }

    public void zza(zzasc zzasc2) throws RemoteException {
        this.zzbkK.zza(zzasc2);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zzaad.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzxC();
        zzac.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzac.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzase)this.zzxD()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzasf.zza {
        private zzaad.zzb<LocationSettingsResult> zzbkL;

        public zzc(zzaad.zzb<LocationSettingsResult> zzb2) {
            zzac.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzbkL = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzbkL.setResult((Object)locationSettingsResult);
            this.zzbkL = null;
        }
    }

    private static final class zzb
    extends zzasd.zza {
        private zzaad.zzb<Status> zzbkL;

        public zzb(zzaad.zzb<Status> zzb2) {
            this.zzbkL = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzkx(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzkx(n);
        }

        private void zzkx(int n) {
            if (this.zzbkL == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzkt(LocationStatusCodes.zzks(n));
            this.zzbkL.setResult((Object)status);
            this.zzbkL = null;
        }
    }

    private static final class zza
    extends zzasd.zza {
        private zzaad.zzb<Status> zzbkL;

        public zza(zzaad.zzb<Status> zzb2) {
            this.zzbkL = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzbkL == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzkt(LocationStatusCodes.zzks(n));
            this.zzbkL.setResult((Object)status);
            this.zzbkL = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

