/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzasm;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzOV = null;
        private int zzbjD = 0;
        private long zzbjE = Long.MIN_VALUE;
        private short zzbjF = (short)-1;
        private double zzbjG;
        private double zzbjH;
        private float zzbjI;
        private int zzbjJ = 0;
        private int zzbjK = -1;

        public Builder setRequestId(String string) {
            this.zzOV = string;
            return this;
        }

        public Builder setTransitionTypes(int n) {
            this.zzbjD = n;
            return this;
        }

        public Builder setExpirationDuration(long l) {
            this.zzbjE = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public Builder setCircularRegion(double d, double d2, float f) {
            this.zzbjF = 1;
            this.zzbjG = d;
            this.zzbjH = d2;
            this.zzbjI = f;
            return this;
        }

        public Builder setNotificationResponsiveness(int n) {
            this.zzbjJ = n;
            return this;
        }

        public Builder setLoiteringDelay(int n) {
            this.zzbjK = n;
            return this;
        }

        public Geofence build() {
            if (this.zzOV == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzbjD == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzbjD & 4) != 0 && this.zzbjK < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzbjE == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzbjF == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzbjJ < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzasm(this.zzOV, this.zzbjD, 1, this.zzbjG, this.zzbjH, this.zzbjI, this.zzbjE, this.zzbjJ, this.zzbjK);
        }
    }
}

