/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.location.zzq;
import java.util.Arrays;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int mPriority;
    private long zzbhX;
    private long zzbhY;
    private boolean zzaXd;
    private long zzbhG;
    private int zzbhZ;
    private float zzbia;
    private long zzbib;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzq();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzbhX = 3600000L;
        this.zzbhY = 600000L;
        this.zzaXd = false;
        this.zzbhG = Long.MAX_VALUE;
        this.zzbhZ = Integer.MAX_VALUE;
        this.zzbia = 0.0f;
        this.zzbib = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.mPriority = n;
        return this;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zzI(l);
        this.zzbhX = l;
        if (!this.zzaXd) {
            this.zzbhY = (long)((double)this.zzbhX / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzbhX;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzI(l);
        this.zzbib = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzbib;
        if (l < this.zzbhX) {
            l = this.zzbhX;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zzI(l);
        this.zzaXd = true;
        this.zzbhY = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzbhY;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzbhG = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzbhG < 0L) {
            this.zzbhG = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zzbhG = l;
        if (this.zzbhG < 0L) {
            this.zzbhG = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zzbhG;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzbhZ = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzbhZ;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzbia = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzbia;
    }

    private static void zzI(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzbhX = l;
        this.zzbhY = l2;
        this.zzaXd = bl;
        this.zzbhG = l3;
        this.zzbhZ = n2;
        this.zzbia = f;
        this.zzbib = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)locationRequest.mPriority);
        zzd.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzbhX);
        zzd.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzbhY);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzaXd);
        zzd.zza((Parcel)parcel2, (int)5, (long)locationRequest.zzbhG);
        zzd.zzc((Parcel)parcel2, (int)6, (int)locationRequest.zzbhZ);
        zzd.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzbia);
        zzd.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzbib);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.mPriority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzbhX).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzbhY).append("ms");
        if (this.zzbib > this.zzbhX) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzbib).append("ms");
        }
        if (this.zzbia > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzbia).append("m");
        }
        if (this.zzbhG != Long.MAX_VALUE) {
            long l = this.zzbhG - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzbhZ != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzbhZ);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mPriority, this.zzbhX, Float.valueOf(this.zzbia), this.zzbib});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzbhX == locationRequest.zzbhX && this.zzbhY == locationRequest.zzbhY && this.zzaXd == locationRequest.zzaXd && this.zzbhG == locationRequest.zzbhG && this.zzbhZ == locationRequest.zzbhZ && this.zzbia == locationRequest.zzbia && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

