/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfm;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.zzag;

public final class zzcfk
extends zzcdt {
    private final zzcfd zzilu;

    public zzcfk(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzr.zzcl((Context)context));
    }

    public zzcfk(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zzr zzr2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzr2);
        this.zzilu = new zzcfd(context, this.zzikt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        zzcfd zzcfd2 = this.zzilu;
        synchronized (zzcfd2) {
            if (this.isConnected()) {
                try {
                    this.zzilu.removeAllListeners();
                    this.zzilu.zzavl();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
            return;
        }
    }

    public final void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzakm();
        zzbq.checkNotNull((Object)pendingIntent);
        zzbq.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzcez)this.zzakn()).zza(l, true, pendingIntent);
    }

    public final void zzc(PendingIntent pendingIntent) throws RemoteException {
        this.zzakm();
        zzbq.checkNotNull((Object)pendingIntent);
        ((zzcez)this.zzakn()).zzc(pendingIntent);
    }

    public final void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzn<Status> zzn2) throws RemoteException {
        this.zzakm();
        zzbq.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        zzbq.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzbq.checkNotNull(zzn2, (Object)"ResultHolder not provided.");
        zzcfl zzcfl2 = new zzcfl(zzn2);
        ((zzcez)this.zzakn()).zza(geofencingRequest, pendingIntent, zzcfl2);
    }

    public final void zza(zzag zzag2, zzn<Status> zzn2) throws RemoteException {
        this.zzakm();
        zzbq.checkNotNull((Object)((Object)zzag2), (Object)"removeGeofencingRequest can't be null.");
        zzbq.checkNotNull(zzn2, (Object)"ResultHolder not provided.");
        zzcfm zzcfm2 = new zzcfm(zzn2);
        ((zzcez)this.zzakn()).zza(zzag2, zzcfm2);
    }

    public final Location getLastLocation() throws RemoteException {
        return this.zzilu.getLastLocation();
    }

    public final LocationAvailability zzavk() throws RemoteException {
        return this.zzilu.zzavk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzcfo zzcfo2, zzci<LocationCallback> zzci2, zzceu zzceu2) throws RemoteException {
        zzcfd zzcfd2 = this.zzilu;
        synchronized (zzcfd2) {
            this.zzilu.zza(zzcfo2, zzci2, zzceu2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(LocationRequest locationRequest, zzci<LocationListener> zzci2, zzceu zzceu2) throws RemoteException {
        zzcfd zzcfd2 = this.zzilu;
        synchronized (zzcfd2) {
            this.zzilu.zza(locationRequest, zzci2, zzceu2);
            return;
        }
    }

    public final void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzceu zzceu2) throws RemoteException {
        this.zzilu.zza(locationRequest, pendingIntent, zzceu2);
    }

    public final void zza(zzck<LocationListener> zzck2, zzceu zzceu2) throws RemoteException {
        this.zzilu.zza(zzck2, zzceu2);
    }

    public final void zza(PendingIntent pendingIntent, zzceu zzceu2) throws RemoteException {
        this.zzilu.zza(pendingIntent, zzceu2);
    }

    public final void zzb(zzck<LocationCallback> zzck2, zzceu zzceu2) throws RemoteException {
        this.zzilu.zzb(zzck2, zzceu2);
    }

    public final void zzbj(boolean bl) throws RemoteException {
        this.zzilu.zzbj(bl);
    }

    public final void zzc(Location location) throws RemoteException {
        this.zzilu.zzc(location);
    }

    public final void zza(zzceu zzceu2) throws RemoteException {
        this.zzilu.zza(zzceu2);
    }

    public final void zza(LocationSettingsRequest locationSettingsRequest, zzn<LocationSettingsResult> zzn2, String string) throws RemoteException {
        this.zzakm();
        zzbq.checkArgument((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzbq.checkArgument((zzn2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzcfn zzcfn2 = new zzcfn(zzn2);
        ((zzcez)this.zzakn()).zza(locationSettingsRequest, zzcfn2, string);
    }
}

