/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzcfs;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzcrt = null;
        private int zziiy = 0;
        private long zziiz = Long.MIN_VALUE;
        private short zzija = (short)-1;
        private double zzijb;
        private double zzijc;
        private float zzijd;
        private int zzije = 0;
        private int zzijf = -1;

        public Builder() {
        }

        public final Builder setRequestId(String string) {
            this.zzcrt = string;
            return this;
        }

        public final Builder setTransitionTypes(int n) {
            this.zziiy = n;
            return this;
        }

        public final Builder setExpirationDuration(long l) {
            this.zziiz = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public final Builder setCircularRegion(double d, double d2, float f) {
            this.zzija = 1;
            this.zzijb = d;
            this.zzijc = d2;
            this.zzijd = f;
            return this;
        }

        public final Builder setNotificationResponsiveness(int n) {
            this.zzije = n;
            return this;
        }

        public final Builder setLoiteringDelay(int n) {
            this.zzijf = n;
            return this;
        }

        public final Geofence build() {
            if (this.zzcrt == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zziiy == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zziiy & 4) != 0 && this.zzijf < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zziiz == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzija == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzije < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzcfs(this.zzcrt, this.zziiy, 1, this.zzijb, this.zzijc, this.zzijd, this.zziiz, this.zzije, this.zzijf);
        }
    }
}

