/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzl;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zzbfm {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzl();
    private final List<zzcfs> zzijj;
    private final int zzijk;
    private final String mTag;

    GeofencingRequest(List<zzcfs> list, int n, String string) {
        this.zzijj = list;
        this.zzijk = n;
        this.mTag = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzijj);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzijk;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, geofencingRequest.zzijj, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        zzbfp.zza((Parcel)parcel2, (int)3, (String)geofencingRequest.mTag, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[");
        stringBuilder.append("geofences=");
        stringBuilder.append(this.zzijj);
        int n = this.zzijk;
        stringBuilder.append(new StringBuilder(30).append(", initialTrigger=").append(n).append(", ").toString());
        String string = String.valueOf(this.mTag);
        stringBuilder.append(string.length() != 0 ? "tag=".concat(string) : new String("tag="));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List<zzcfs> zzijj = new ArrayList<zzcfs>();
        private int zzijk = 5;
        private String mTag = "";

        public Builder() {
        }

        public final Builder addGeofence(Geofence geofence) {
            zzbq.checkNotNull((Object)geofence, (Object)"geofence can't be null.");
            zzbq.checkArgument((boolean)(geofence instanceof zzcfs), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzijj.add((zzcfs)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzijk = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            zzbq.checkArgument((!this.zzijj.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzijj, this.zzijk, this.mTag);
        }
    }
}

