/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.location.zzw;
import java.util.Arrays;

public final class LocationRequest
extends zzbfm
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int mPriority;
    private long zzijq;
    private long zzijr;
    private boolean zzhhr;
    private long zziiz;
    private int zziiv;
    private float zzijs;
    private long zzijt;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzw();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzijq = 3600000L;
        this.zzijr = 600000L;
        this.zzhhr = false;
        this.zziiz = Long.MAX_VALUE;
        this.zziiv = Integer.MAX_VALUE;
        this.zzijs = 0.0f;
        this.zzijt = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.mPriority = n;
        return this;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zzai(l);
        this.zzijq = l;
        if (!this.zzhhr) {
            this.zzijr = (long)((double)this.zzijq / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzijq;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzai(l);
        this.zzijt = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzijt;
        if (l < this.zzijq) {
            l = this.zzijq;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zzai(l);
        this.zzhhr = true;
        this.zzijr = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzijr;
    }

    public final boolean isFastestIntervalExplicitlySet() {
        return this.zzhhr;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zziiz = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zziiz < 0L) {
            this.zziiz = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zziiz = l;
        if (this.zziiz < 0L) {
            this.zziiz = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zziiz;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zziiv = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zziiv;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzijs = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzijs;
    }

    private static void zzai(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzijq = l;
        this.zzijr = l2;
        this.zzhhr = bl;
        this.zziiz = l3;
        this.zziiv = n2;
        this.zzijs = f;
        this.zzijt = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)locationRequest.mPriority);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzijq);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzijr);
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzhhr);
        zzbfp.zza((Parcel)parcel2, (int)5, (long)locationRequest.zziiz);
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)locationRequest.zziiv);
        zzbfp.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzijs);
        zzbfp.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzijt);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.mPriority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzijq).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzijr).append("ms");
        if (this.zzijt > this.zzijq) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzijt).append("ms");
        }
        if (this.zzijs > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzijs).append("m");
        }
        if (this.zziiz != Long.MAX_VALUE) {
            long l = this.zziiz - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zziiv != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zziiv);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mPriority, this.zzijq, Float.valueOf(this.zzijs), this.zzijt});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzijq == locationRequest.zzijq && this.zzijr == locationRequest.zzijr && this.zzhhr == locationRequest.zzhhr && this.zziiz == locationRequest.zziiz && this.zziiv == locationRequest.zziiv && this.zzijs == locationRequest.zzijs && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

