/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzceb;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.GeofencingApi;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.SettingsApi;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.location.zzy;

public class LocationServices {
    private static final Api.zzf<zzcfk> zzebf = new Api.zzf();
    private static final Api.zza<zzcfk, Api.ApiOptions.NoOptions> zzebg = new zzy();
    public static final Api<Api.ApiOptions.NoOptions> API = new Api("LocationServices.API", zzebg, zzebf);
    @Deprecated
    public static final FusedLocationProviderApi FusedLocationApi = new zzceb();
    @Deprecated
    public static final GeofencingApi GeofencingApi = new zzceq();
    @Deprecated
    public static final SettingsApi SettingsApi = new zzcfv();

    private LocationServices() {
    }

    public static zzcfk zzh(GoogleApiClient googleApiClient) {
        zzbq.checkArgument((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzcfk zzcfk2 = (zzcfk)googleApiClient.zza(zzebf);
        zzbq.zza((zzcfk2 != null ? 1 : 0) != 0, (Object)"GoogleApiClient is not configured to use the LocationServices.API Api. Pass thisinto GoogleApiClient.Builder#addApi() to use this feature.");
        return zzcfk2;
    }

    public static GeofencingClient getGeofencingClient(@NonNull Activity activity) {
        return new GeofencingClient(activity);
    }

    public static GeofencingClient getGeofencingClient(@NonNull Context context) {
        return new GeofencingClient(context);
    }

    public static SettingsClient getSettingsClient(@NonNull Activity activity) {
        return new SettingsClient(activity);
    }

    public static SettingsClient getSettingsClient(@NonNull Context context) {
        return new SettingsClient(context);
    }

    public static FusedLocationProviderClient getFusedLocationProviderClient(@NonNull Activity activity) {
        return new FusedLocationProviderClient(activity);
    }

    public static FusedLocationProviderClient getFusedLocationProviderClient(@NonNull Context context) {
        return new FusedLocationProviderClient(context);
    }

    public static abstract class zza<R extends Result>
    extends zzm<R, zzcfk> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }
    }
}

