/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzchq;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

@Hide
public final class zzchp
extends zzbgl
implements Geofence {
    private final String zza;
    private final long zzb;
    private final short zzc;
    private final double zzd;
    private final double zze;
    private final float zzf;
    private final int zzg;
    private final int zzh;
    private final int zzi;
    public static final Parcelable.Creator<zzchp> CREATOR = new zzchq();

    public zzchp(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzc = s;
        this.zza = string;
        this.zzd = d;
        this.zze = d2;
        this.zzf = f;
        this.zzb = l;
        this.zzg = n;
        this.zzh = n2;
        this.zzi = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zza;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzchp zzchp2 = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)zzchp2.getRequestId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)zzchp2.zzb);
        zzbgo.zza((Parcel)parcel2, (int)3, (short)zzchp2.zzc);
        zzbgo.zza((Parcel)parcel2, (int)4, (double)zzchp2.zzd);
        zzbgo.zza((Parcel)parcel2, (int)5, (double)zzchp2.zze);
        zzbgo.zza((Parcel)parcel2, (int)6, (float)zzchp2.zzf);
        zzbgo.zza((Parcel)parcel2, (int)7, (int)zzchp2.zzg);
        zzbgo.zza((Parcel)parcel2, (int)8, (int)zzchp2.zzh);
        zzbgo.zza((Parcel)parcel2, (int)9, (int)zzchp2.zzi);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static zzchp zza(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzchp zzchp2 = (zzchp)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzchp2;
    }

    @Hide
    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzc) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zza.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zzg;
        objectArray[3] = this.zzd;
        objectArray[4] = this.zze;
        objectArray[5] = Float.valueOf(this.zzf);
        objectArray[6] = this.zzh / 1000;
        objectArray[7] = this.zzi;
        objectArray[8] = this.zzb;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    @Hide
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzd);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zze);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzf);
        n = n * 31 + this.zzc;
        return n * 31 + this.zzg;
    }

    @Hide
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzchp)) {
            return false;
        }
        zzchp zzchp2 = (zzchp)object;
        if (this.zzf != zzchp2.zzf) {
            return false;
        }
        if (this.zzd != zzchp2.zzd) {
            return false;
        }
        if (this.zze != zzchp2.zze) {
            return false;
        }
        return this.zzc == zzchp2.zzc;
    }
}

