/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.location.zzab;
import java.util.Arrays;

public final class LocationRequest
extends zzbgl
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int zza;
    private long zzb;
    private long zzc;
    private boolean zzd;
    private long zze;
    private int zzf;
    private float zzg;
    private long zzh;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzab();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    @Hide
    public LocationRequest() {
        this.zza = 102;
        this.zzb = 3600000L;
        this.zzc = 600000L;
        this.zzd = false;
        this.zze = Long.MAX_VALUE;
        this.zzf = Integer.MAX_VALUE;
        this.zzg = 0.0f;
        this.zzh = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.zza = n;
        return this;
    }

    public final int getPriority() {
        return this.zza;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zza(l);
        this.zzb = l;
        if (!this.zzd) {
            this.zzc = (long)((double)this.zzb / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzb;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zza(l);
        this.zzh = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzh;
        if (l < this.zzb) {
            l = this.zzb;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zza(l);
        this.zzd = true;
        this.zzc = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzc;
    }

    public final boolean isFastestIntervalExplicitlySet() {
        return this.zzd;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zze = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zze < 0L) {
            this.zze = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zze = l;
        if (this.zze < 0L) {
            this.zze = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zze;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzf = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzf;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzg = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzg;
    }

    private static void zza(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    @Hide
    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.zza = n;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = bl;
        this.zze = l3;
        this.zzf = n2;
        this.zzg = f;
        this.zzh = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)locationRequest.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzb);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzc);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzd);
        zzbgo.zza((Parcel)parcel2, (int)5, (long)locationRequest.zze);
        zzbgo.zza((Parcel)parcel2, (int)6, (int)locationRequest.zzf);
        zzbgo.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzg);
        zzbgo.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzh);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.zza) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.zza != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzb).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzc).append("ms");
        if (this.zzh > this.zzb) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzh).append("ms");
        }
        if (this.zzg > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzg).append("m");
        }
        if (this.zze != Long.MAX_VALUE) {
            long l = this.zze - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzf != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzf);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, Float.valueOf(this.zzg), this.zzh});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.zza == locationRequest.zza && this.zzb == locationRequest.zzb && this.zzc == locationRequest.zzc && this.zzd == locationRequest.zzd && this.zze == locationRequest.zze && this.zzf == locationRequest.zzf && this.zzg == locationRequest.zzg && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

