/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcfq;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.zzal;

@Hide
public final class zzchh
extends zzcfq {
    private final zzcha zziuk;

    public zzchh(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzr.zzcm((Context)context));
    }

    public zzchh(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zzr zzr2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzr2);
        this.zziuk = new zzcha(context, this.zzitk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        zzcha zzcha2 = this.zziuk;
        synchronized (zzcha2) {
            if (this.isConnected()) {
                try {
                    this.zziuk.removeAllListeners();
                    this.zziuk.zzaxc();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
            return;
        }
    }

    public final void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzalv();
        zzbq.checkNotNull((Object)pendingIntent);
        zzbq.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzcgw)this.zzalw()).zza(l, true, pendingIntent);
    }

    public final void zza(ActivityTransitionRequest activityTransitionRequest, PendingIntent pendingIntent, zzn<Status> zzn2) throws RemoteException {
        this.zzalv();
        zzbq.checkNotNull(zzn2, (Object)"ResultHolder not provided.");
        zzcz zzcz2 = new zzcz(zzn2);
        ((zzcgw)this.zzalw()).zza(activityTransitionRequest, pendingIntent, (zzca)zzcz2);
    }

    public final void zza(PendingIntent pendingIntent, zzn<Status> zzn2) throws RemoteException {
        this.zzalv();
        zzbq.checkNotNull(zzn2, (Object)"ResultHolder not provided.");
        zzcz zzcz2 = new zzcz(zzn2);
        ((zzcgw)this.zzalw()).zza(pendingIntent, (zzca)zzcz2);
    }

    public final void zzc(PendingIntent pendingIntent) throws RemoteException {
        this.zzalv();
        zzbq.checkNotNull((Object)pendingIntent);
        ((zzcgw)this.zzalw()).zzc(pendingIntent);
    }

    public final void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzn<Status> zzn2) throws RemoteException {
        this.zzalv();
        zzbq.checkNotNull((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        zzbq.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzbq.checkNotNull(zzn2, (Object)"ResultHolder not provided.");
        zzchi zzchi2 = new zzchi(zzn2);
        ((zzcgw)this.zzalw()).zza(geofencingRequest, pendingIntent, zzchi2);
    }

    public final void zza(zzal zzal2, zzn<Status> zzn2) throws RemoteException {
        this.zzalv();
        zzbq.checkNotNull((Object)((Object)zzal2), (Object)"removeGeofencingRequest can't be null.");
        zzbq.checkNotNull(zzn2, (Object)"ResultHolder not provided.");
        zzchj zzchj2 = new zzchj(zzn2);
        ((zzcgw)this.zzalw()).zza(zzal2, zzchj2);
    }

    public final Location getLastLocation() throws RemoteException {
        return this.zziuk.getLastLocation();
    }

    public final LocationAvailability zzaxb() throws RemoteException {
        return this.zziuk.zzaxb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzchl zzchl2, zzci<LocationCallback> zzci2, zzcgr zzcgr2) throws RemoteException {
        zzcha zzcha2 = this.zziuk;
        synchronized (zzcha2) {
            this.zziuk.zza(zzchl2, zzci2, zzcgr2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(LocationRequest locationRequest, zzci<LocationListener> zzci2, zzcgr zzcgr2) throws RemoteException {
        zzcha zzcha2 = this.zziuk;
        synchronized (zzcha2) {
            this.zziuk.zza(locationRequest, zzci2, zzcgr2);
            return;
        }
    }

    public final void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzcgr zzcgr2) throws RemoteException {
        this.zziuk.zza(locationRequest, pendingIntent, zzcgr2);
    }

    public final void zza(zzck<LocationListener> zzck2, zzcgr zzcgr2) throws RemoteException {
        this.zziuk.zza(zzck2, zzcgr2);
    }

    public final void zza(PendingIntent pendingIntent, zzcgr zzcgr2) throws RemoteException {
        this.zziuk.zza(pendingIntent, zzcgr2);
    }

    public final void zzb(zzck<LocationCallback> zzck2, zzcgr zzcgr2) throws RemoteException {
        this.zziuk.zzb(zzck2, zzcgr2);
    }

    public final void zzbo(boolean bl) throws RemoteException {
        this.zziuk.zzbo(bl);
    }

    public final void zzc(Location location) throws RemoteException {
        this.zziuk.zzc(location);
    }

    public final void zza(zzcgr zzcgr2) throws RemoteException {
        this.zziuk.zza(zzcgr2);
    }

    public final void zza(LocationSettingsRequest locationSettingsRequest, zzn<LocationSettingsResult> zzn2, String string) throws RemoteException {
        this.zzalv();
        zzbq.checkArgument((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzbq.checkArgument((zzn2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzchk zzchk2 = new zzchk(zzn2);
        ((zzcgw)this.zzalw()).zza(locationSettingsRequest, zzchk2, string);
    }
}

